/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.core.rate.limit.TimeWindow;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import java.util.Arrays;

final class RingBufferRollingWindow
implements TimeWindow {
    private final RunningStopwatch stopwatch;
    private final long timeWindowInMillis;
    private final long minSpacingInMillis;
    private final long[] timestamps;
    private int head;
    private int tail;

    RingBufferRollingWindow(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        this.stopwatch = stopwatch.start();
        this.timeWindowInMillis = timeWindowInMillis;
        this.minSpacingInMillis = minSpacingInMillis;
        this.timestamps = new long[maxInvocations];
        Arrays.fill(this.timestamps, Long.MAX_VALUE);
        this.head = -1;
        this.tail = 0;
    }

    @Override
    public synchronized boolean record() {
        long previous;
        boolean allowInvocation;
        long now = this.stopwatch.elapsedTimeInMillis();
        long validity = now - this.timeWindowInMillis;
        while (this.timestamps[this.tail] <= validity && this.head != this.tail) {
            this.advanceTail();
        }
        boolean isFull = this.isFull();
        boolean bl = allowInvocation = !isFull;
        if (allowInvocation && this.minSpacingInMillis != 0L && this.head >= 0 && (previous = this.timestamps[this.head]) != Long.MAX_VALUE && now - previous < this.minSpacingInMillis) {
            allowInvocation = false;
        }
        if (isFull) {
            this.advanceTail();
        }
        this.advanceHead();
        this.timestamps[this.head] = now;
        return allowInvocation;
    }

    private boolean isFull() {
        if (this.head < 0) {
            return false;
        }
        return (this.head - this.tail + 1) % this.timestamps.length == 0;
    }

    private void advanceHead() {
        this.head = (this.head + 1) % this.timestamps.length;
    }

    private void advanceTail() {
        this.tail = (this.tail + 1) % this.timestamps.length;
    }
}

