/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.dispatcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.jgroups.BytesMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.server.infinispan.ClusteringServerLogger;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.NoSuchService;

public class CommandDispatcherRequestCorrelator
extends RequestCorrelator {
    private final ByteBufferMarshaller marshaller;
    private final Predicate<Message> unknownForkPredicate;

    public CommandDispatcherRequestCorrelator(JChannel channel, RequestHandler handler, ChannelCommandDispatcherFactoryConfiguration config) {
        super((Protocol)channel.getProtocolStack(), handler, channel.getAddress());
        this.marshaller = config.getMarshaller();
        this.unknownForkPredicate = config.getUnknownForkPredicate();
        this.corr_id = ClassConfigurator.getProtocolId(RequestCorrelator.class);
    }

    protected void dispatch(Message message, RequestCorrelator.Header header) {
        boolean exception = false;
        switch (header.type) {
            case 0: {
                this.handleRequest(message, header);
                break;
            }
            case 2: {
                exception = true;
            }
            case 1: {
                Request request = (Request)this.requests.get(header.req_id);
                if (request == null) break;
                try {
                    Object response = this.readPayload(message);
                    request.receiveResponse(response, message.getSrc(), exception);
                }
                catch (IOException e) {
                    ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    request.receiveResponse((Object)e, message.getSrc(), true);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(header.toString());
            }
        }
    }

    private Object readPayload(Message message) throws IOException {
        if (this.unknownForkPredicate.test(message)) {
            return NoSuchService.INSTANCE;
        }
        if (message.isFlagSet(Message.Flag.SERIALIZED)) {
            return message.getObject();
        }
        ByteBuffer buffer = ByteBuffer.wrap(message.getArray(), message.getOffset(), message.getLength());
        return this.marshaller.read(buffer);
    }

    protected void sendReply(Message request, long requestId, Object reply, boolean exception) {
        Message response = new BytesMessage(request.getSrc()).setFlag(request.getFlags(false), false).clearFlag(new Message.Flag[]{Message.Flag.RSVP});
        if (request.getDest() != null) {
            response.setSrc(request.getDest());
        }
        try {
            ByteBuffer buffer = this.marshaller.write(reply);
            response.setArray(buffer.array(), buffer.arrayOffset(), buffer.limit() - buffer.arrayOffset());
        }
        catch (IOException e) {
            ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            response.setObject((Object)e);
        }
        this.sendResponse(response, requestId, exception);
    }
}

