/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.SqlTypes;

public final class JdbcTypeNameMapper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JdbcTypeNameMapper.class);
    private static final Map<Integer, String> JDBC_TYPE_MAP = JdbcTypeNameMapper.buildJdbcTypeMap(Types.class);
    private static final Map<Integer, String> SQL_TYPE_MAP = JdbcTypeNameMapper.buildJdbcTypeMap(SqlTypes.class);
    private static final Map<String, Integer> JDBC_TYPE_NAME_MAP = JdbcTypeNameMapper.buildJdbcTypeNameMap(Types.class);
    private static final Map<String, Integer> SQL_TYPE_NAME_MAP = JdbcTypeNameMapper.buildJdbcTypeNameMap(SqlTypes.class);

    private static Map<Integer, String> buildJdbcTypeMap(Class<?> typesClass) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (Field field : typesClass.getFields()) {
            try {
                int code = field.getInt(null);
                String old = map.put(code, field.getName());
                if (old == null) continue;
                LOG.JavaSqlTypesMappedSameCodeMultipleTimes(code, old, field.getName());
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to access JDBC type mapping [" + field.getName() + "]", e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, Integer> buildJdbcTypeNameMap(Class<?> typesClass) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Field field : typesClass.getFields()) {
            try {
                int code = field.getInt(null);
                map.put(field.getName(), code);
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to access JDBC type mapping [" + field.getName() + "]", e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static boolean isStandardTypeCode(int typeCode) {
        return JdbcTypeNameMapper.isStandardTypeCode((Integer)typeCode);
    }

    public static boolean isStandardTypeCode(Integer typeCode) {
        return JDBC_TYPE_MAP.containsKey(typeCode);
    }

    public static String getTypeName(Integer typeCode) {
        String name = SQL_TYPE_MAP.get(typeCode);
        if (name == null) {
            return "UNKNOWN(" + typeCode + ")";
        }
        return name;
    }

    public static Integer getTypeCode(String typeName) {
        return SQL_TYPE_NAME_MAP.get(typeName);
    }

    private JdbcTypeNameMapper() {
    }
}

