/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.util.Collections;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.deployment.JmsDestination;
import org.wildfly.extension.messaging.activemq.deployment.Namespace;
import org.wildfly.extension.messaging.activemq.deployment.ParseResult;

class MessagingDeploymentParser_1_0
implements XMLStreamConstants,
XMLElementReader<ParseResult> {
    private final PropertyReplacer propertyReplacer;

    MessagingDeploymentParser_1_0(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
        switch (schemaVer) {
            case MESSAGING_DEPLOYMENT_1_0: {
                this.processDeployment(reader, result);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void processDeployment(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "server": {
                    this.processServer(reader, result);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processServer(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        String serverName = null;
        int count = reader.getAttributeCount();
        if (count > 0) {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            serverName = this.propertyReplacer.replaceProperties(reader.getAttributeValue(0).trim());
        }
        if (serverName == null || serverName.length() == 0) {
            serverName = "default";
        }
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "jms-destinations": {
                    this.processJmsDestinations(reader, result, serverName);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processJmsDestinations(XMLExtendedStreamReader reader, ParseResult result, String serverName) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "jms-queue": {
                    this.processJMSQueue(reader, serverName, result);
                    continue block8;
                }
                case "jms-topic": {
                    this.processJMSTopic(reader, serverName, result);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processJMSTopic(XMLExtendedStreamReader reader, String serverName, ParseResult result) throws XMLStreamException {
        String name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(0));
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode topic = new ModelNode();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "entry": {
                    String entry = this.propertyReplacer.replaceProperties(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    MessagingDeploymentParser_1_0.parseAndAddParameter((AttributeDefinition)CommonAttributes.DESTINATION_ENTRIES, entry, topic, (XMLStreamReader)reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.getTopics().add(new JmsDestination(topic, serverName, name));
    }

    private void processJMSQueue(XMLExtendedStreamReader reader, String serverName, ParseResult result) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(0));
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode queue = new ModelNode();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "entry": {
                    String entry = this.propertyReplacer.replaceProperties(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    MessagingDeploymentParser_1_0.parseAndAddParameter((AttributeDefinition)CommonAttributes.DESTINATION_ENTRIES, entry, queue, (XMLStreamReader)reader);
                    continue block10;
                }
                case "selector": {
                    if (queue.has(CommonAttributes.SELECTOR.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"string");
                    String selector = this.propertyReplacer.replaceProperties(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string"));
                    CommonAttributes.SELECTOR.parseAndSetParameter(selector, queue, (XMLStreamReader)reader);
                    continue block10;
                }
                case "durable": {
                    if (queue.has(CommonAttributes.DURABLE.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    CommonAttributes.DURABLE.parseAndSetParameter(this.propertyReplacer.replaceProperties(reader.getElementText()), queue, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.getQueues().add(new JmsDestination(queue, serverName, name));
    }

    protected static void parseAndAddParameter(AttributeDefinition ad, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode attValue = ad.getParser().parse(ad, value, reader);
        operation.get(ad.getName()).add(attValue);
    }
}

