/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Iterator;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import mutiny.zero.internal.Helper;

class IteratorSubscription<T>
implements Flow.Subscription {
    private final Flow.Subscriber<? super T> subscriber;
    private volatile boolean cancelled = false;
    private final Iterator<T> iterator;
    private final AtomicLong requested = new AtomicLong();

    IteratorSubscription(Iterator<T> iterator, Flow.Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
        this.iterator = iterator;
    }

    @Override
    public void request(long n) {
        if (n <= 0L) {
            this.cancel();
            this.subscriber.onError(Helper.negativeRequest(n));
            return;
        }
        if (Helper.add(this.requested, n) == 0L) {
            if (n == Long.MAX_VALUE) {
                this.deliverAll();
            } else {
                this.deliver(n);
            }
        }
    }

    private void deliver(long n) {
        long emitted = 0L;
        while (!this.cancelled) {
            while (emitted != n) {
                if (this.iterator.hasNext()) {
                    T next;
                    try {
                        next = this.iterator.next();
                    }
                    catch (Throwable err) {
                        this.subscriber.onError(err);
                        return;
                    }
                    if (next == null) {
                        this.cancelled = true;
                        this.subscriber.onError(new NullPointerException("The iterable has a null value"));
                        return;
                    }
                    this.subscriber.onNext(next);
                    ++emitted;
                    continue;
                }
                this.subscriber.onComplete();
                return;
            }
            n = this.requested.get();
            if (n != emitted) continue;
            n = this.requested.addAndGet(-emitted);
            if (n == 0L) {
                return;
            }
            emitted = 0L;
        }
        return;
    }

    private void deliverAll() {
        while (this.iterator.hasNext()) {
            if (this.cancelled) {
                return;
            }
            T next = this.iterator.next();
            if (next == null) {
                this.cancelled = true;
                this.subscriber.onError(new NullPointerException("The iterable has a null value"));
                return;
            }
            this.subscriber.onNext(next);
        }
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.subscriber.onComplete();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

