/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformationContextImpl;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.dmr.ModelNode;

public class TransformersImpl
implements Transformers {
    private final TransformationTarget target;

    TransformersImpl(TransformationTarget target) {
        assert (target != null);
        this.target = target;
    }

    @Override
    public TransformationTarget getTarget() {
        return this.target;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        ImmutableManagementResourceRegistration reg = context.getResourceRegistration(address);
        PathAddress useAddress = reg != null && reg.isAlias() ? reg.getAliasEntry().convertToTargetAddress(address, AliasEntry.AliasContext.create(operation, context)) : address;
        String operationName = operation.require("operation").asString();
        TransformationContext opCtx = ResourceTransformationContextImpl.wrapForOperation(context, operation);
        OperationTransformer transformer = this.target.resolveTransformer(opCtx, useAddress, operationName);
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("operation %s does not need transformation", operation);
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
        PathAddress transformed = TransformersImpl.transformAddress(useAddress, this.target);
        operation.get("address").set(transformed.toModelNode());
        OperationTransformer.TransformedOperation res = transformer.transformOperation(opCtx, transformed, operation);
        context.getLogger().flushLogQueue();
        return res;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(Transformers.TransformationInputs transformationInputs, ModelNode operation) throws OperationFailedException {
        PathAddress original = PathAddress.pathAddress(operation.require("address"));
        ImmutableManagementResourceRegistration reg = transformationInputs.getRootRegistration().getSubModel(original);
        PathAddress useAddress = reg != null && reg.isAlias() ? reg.getAliasEntry().convertToTargetAddress(original, AliasEntry.AliasContext.create(operation, transformationInputs)) : original;
        String operationName = operation.require("operation").asString();
        PathAddress transformed = TransformersImpl.transformAddress(useAddress, this.target);
        operation.get("address").set(transformed.toModelNode());
        ResourceTransformationContext context = ResourceTransformationContextImpl.create(transformationInputs, this.target, transformed, original, Transformers.DEFAULT);
        OperationTransformer transformer = this.target.resolveTransformer(context, useAddress, operationName);
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("operation %s does not need transformation", operation);
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
        OperationTransformer.TransformedOperation op = transformer.transformOperation(context, transformed, operation);
        context.getLogger().flushLogQueue();
        return op;
    }

    @Override
    public Resource transformRootResource(Transformers.TransformationInputs transformationInputs, Resource resource) throws OperationFailedException {
        return this.transformRootResource(transformationInputs, resource, Transformers.DEFAULT);
    }

    @Override
    public Resource transformRootResource(Transformers.TransformationInputs transformationInputs, Resource resource, Transformers.ResourceIgnoredTransformationRegistry ignoredTransformationRegistry) throws OperationFailedException {
        PathAddress original = PathAddress.EMPTY_ADDRESS;
        PathAddress transformed = TransformersImpl.transformAddress(original, this.target);
        ResourceTransformationContext context = ResourceTransformationContextImpl.create(transformationInputs, this.target, transformed, original, ignoredTransformationRegistry);
        ResourceTransformer transformer = this.target.resolveTransformer(context, original);
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("resource %s does not need transformation", resource);
            return resource;
        }
        transformer.transformResource(context, transformed, resource);
        context.getLogger().flushLogQueue();
        return context.getTransformedRoot();
    }

    @Override
    public Resource transformResource(ResourceTransformationContext context, Resource resource) throws OperationFailedException {
        ResourceTransformer transformer = this.target.resolveTransformer(context, PathAddress.EMPTY_ADDRESS);
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("resource %s does not need transformation", resource);
            return resource;
        }
        transformer.transformResource(context, PathAddress.EMPTY_ADDRESS, resource);
        context.getLogger().flushLogQueue();
        return context.getTransformedRoot();
    }

    protected static PathAddress transformAddress(PathAddress original, TransformationTarget target) {
        List<PathAddressTransformer> transformers = target.getPathTransformation(original);
        Iterator<PathAddressTransformer> transformations = transformers.iterator();
        PathAddressTransformer.BuilderImpl builder = new PathAddressTransformer.BuilderImpl(transformations, original);
        return builder.start();
    }
}

