/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.AbstractMap;
import java.util.Map;
import org.wildfly.clustering.context.ThreadContextReference;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum ContextClassLoaderReference implements ThreadContextReference<ClassLoader>
{
    INSTANCE;

    private static final ParametricPrivilegedAction<ClassLoader, Thread> GET_CONTEXT_CLASS_LOADER_ACTION;
    private static final ParametricPrivilegedAction<Void, Map.Entry<Thread, ClassLoader>> SET_CONTEXT_CLASS_LOADER_ACTION;

    @Override
    public ClassLoader apply(Thread thread) {
        return (ClassLoader)WildFlySecurityManager.doUnchecked((Object)thread, GET_CONTEXT_CLASS_LOADER_ACTION);
    }

    @Override
    public void accept(Thread thread, ClassLoader loader) {
        WildFlySecurityManager.doUnchecked(new AbstractMap.SimpleImmutableEntry<Thread, ClassLoader>(thread, loader), SET_CONTEXT_CLASS_LOADER_ACTION);
    }

    static {
        GET_CONTEXT_CLASS_LOADER_ACTION = new ParametricPrivilegedAction<ClassLoader, Thread>(){

            public ClassLoader run(Thread thread) {
                return thread.getContextClassLoader();
            }
        };
        SET_CONTEXT_CLASS_LOADER_ACTION = new ParametricPrivilegedAction<Void, Map.Entry<Thread, ClassLoader>>(){

            public Void run(Map.Entry<Thread, ClassLoader> entry) {
                entry.getKey().setContextClassLoader(entry.getValue());
                return null;
            }
        };
    }
}

