/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchRangeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchTermsAggregation;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchRangePredicate;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchJsonElementFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchNativeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicate;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSort;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.search.aggregation.spi.AggregationTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;

class ElasticsearchNativeIndexFieldTypeOptionsStepImpl
extends AbstractElasticsearchIndexFieldTypeOptionsStep<ElasticsearchNativeIndexFieldTypeOptionsStepImpl, JsonElement>
implements ElasticsearchNativeIndexFieldTypeOptionsStep<ElasticsearchNativeIndexFieldTypeOptionsStepImpl> {
    ElasticsearchNativeIndexFieldTypeOptionsStepImpl(ElasticsearchIndexFieldTypeBuildContext buildContext, PropertyMapping mapping) {
        super(buildContext, JsonElement.class, mapping);
    }

    @Override
    protected ElasticsearchNativeIndexFieldTypeOptionsStepImpl thisAsS() {
        return this;
    }

    public IndexFieldType<JsonElement> toIndexFieldType() {
        Gson gson = this.buildContext.getUserFacingGson();
        ElasticsearchJsonElementFieldCodec codec = new ElasticsearchJsonElementFieldCodec(gson);
        this.builder.codec(codec);
        this.builder.searchable(true);
        this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new ElasticsearchStandardMatchPredicate.Factory<JsonElement>(codec));
        this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new ElasticsearchRangePredicate.Factory<JsonElement>(codec));
        this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new ElasticsearchExistsPredicate.Factory());
        this.builder.sortable(true);
        this.builder.queryElementFactory(SortTypeKeys.FIELD, new ElasticsearchStandardFieldSort.Factory<JsonElement>(codec));
        this.builder.projectable(true);
        this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new ElasticsearchFieldProjection.Factory<JsonElement>(codec));
        this.builder.aggregable(true);
        this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new ElasticsearchTermsAggregation.Factory<JsonElement>(codec));
        this.builder.queryElementFactory(AggregationTypeKeys.RANGE, new ElasticsearchRangeAggregation.Factory<JsonElement>(codec));
        return this.builder.build();
    }
}

