/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.transaction.Synchronization;
import java.lang.invoke.MethodHandles;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class SynchronizationAdapter
implements Synchronization,
BeforeTransactionCompletionProcess,
AfterTransactionCompletionProcess {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Synchronization delegate;
    private boolean beforeExecuted = false;
    private boolean afterExecuted = false;

    SynchronizationAdapter(Synchronization delegate) {
        this.delegate = delegate;
    }

    public void beforeCompletion() {
        this.doBeforeCompletion();
    }

    public void afterCompletion(int status) {
        log.tracef("Transaction's afterCompletion is expected to be executed through the AfterTransactionCompletionProcess interface, ignoring: %s", this.delegate);
    }

    public void doBeforeTransactionCompletion(SessionImplementor sessionImplementor) {
        try {
            this.doBeforeCompletion();
        }
        catch (RuntimeException e) {
            throw log.synchronizationBeforeTransactionFailure(e.getMessage(), e);
        }
    }

    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor sessionImplementor) {
        try {
            this.doAfterCompletion(success ? 3 : 4);
        }
        catch (RuntimeException e) {
            throw log.synchronizationAfterTransactionFailure(e.getMessage(), e);
        }
    }

    private void doBeforeCompletion() {
        if (this.beforeExecuted) {
            log.tracef("Transaction's beforeCompletion() phase already been processed, ignoring: %s", this.delegate);
        } else {
            this.delegate.beforeCompletion();
            this.beforeExecuted = true;
        }
    }

    private void doAfterCompletion(int status) {
        if (this.afterExecuted) {
            log.tracef("Transaction's afterCompletion() phase already been processed, ignoring: %s", this.delegate);
        } else {
            this.delegate.afterCompletion(status);
            this.afterExecuted = true;
        }
    }
}

