/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.model;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import io.narayana.lra.logging.LRALogger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class LRAParentAbstractRecord
extends AbstractRecord {
    private boolean committed;
    private URI parentId;
    private URI childId;

    public LRAParentAbstractRecord() {
    }

    public LRAParentAbstractRecord(BasicAction parent, LongRunningAction child) {
        super(new Uid());
        if (parent instanceof LongRunningAction) {
            this.parentId = ((LongRunningAction)parent).getId();
        }
        this.childId = child.getId();
        this.committed = false;
    }

    public void childCommitted() {
        this.committed = true;
    }

    public boolean save_state(OutputObjectState os, int i) {
        boolean saved = super.save_state(os, i);
        if (saved) {
            try {
                os.packString(this.parentId.toASCIIString());
                os.packString(this.childId.toASCIIString());
                os.packBoolean(this.committed);
            }
            catch (IOException e) {
                LRALogger.i18nLogger.warn_saveState(e.getMessage());
                return false;
            }
        }
        return saved;
    }

    public boolean restore_state(InputObjectState os, int i) {
        boolean restored = super.restore_state(os, i);
        if (restored) {
            try {
                this.parentId = new URI(Objects.requireNonNull(os.unpackString()));
                this.childId = new URI(Objects.requireNonNull(os.unpackString()));
                this.committed = os.unpackBoolean();
            }
            catch (IOException | URISyntaxException e) {
                LRALogger.i18nLogger.warn_restoreState(e.getMessage());
                return false;
            }
        }
        return restored;
    }

    public LongRunningAction getParentLRA() {
        return LRARecoveryModule.getService().getTransaction(this.parentId);
    }

    public LongRunningAction getChildLRA() {
        return LRARecoveryModule.getService().getTransaction(this.childId);
    }

    private static int getTypeId() {
        return 168;
    }

    public int typeIs() {
        return LRAParentAbstractRecord.getTypeId();
    }

    public Object value() {
        return null;
    }

    public void setValue(Object o) {
    }

    public int nestedAbort() {
        return 7;
    }

    public int nestedCommit() {
        return 7;
    }

    public int nestedPrepare() {
        return 7;
    }

    public int topLevelAbort() {
        return this.abort(this.getChildLRA());
    }

    private int abort(LongRunningAction lra) {
        if (lra != null && lra.finishLRA(true) != 7) {
            return 6;
        }
        return 7;
    }

    public int topLevelCommit() {
        LongRunningAction parent = this.getParentLRA();
        LongRunningAction child = this.getChildLRA();
        if (parent == null || child == null) {
            return 8;
        }
        if (parent.isCancel()) {
            return this.topLevelAbort();
        }
        if (this.committed) {
            child.forget();
        }
        if (child.finishLRA(false) != 7) {
            return 6;
        }
        return 7;
    }

    public int topLevelPrepare() {
        return 0;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }
}

