/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import javax.naming.Name;
import javax.naming.NamingException;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.naming.client.CurrentNamingProvider;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import org.wildfly.naming.client.NamingOperation;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.RetryContext;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.security.auth.client.PeerIdentity;

public interface NamingProvider
extends AutoCloseable {
    public ProviderEnvironment getProviderEnvironment();

    default public PeerIdentity getPeerIdentityForNaming() throws NamingException {
        return this.getPeerIdentityForNamingUsingRetry(null);
    }

    default public PeerIdentity getPeerIdentityForNamingUsingRetry(RetryContext context) throws NamingException {
        ProviderEnvironment environment = this.getProviderEnvironment();
        ConcurrentMap<URI, Long> blocklist = environment.getBlocklist();
        List<URI> locations = environment.getProviderUris();
        if (context != null && (blocklist.size() > 0 || context.transientFailCount() > 0)) {
            long time = System.currentTimeMillis();
            ArrayList<URI> updated = new ArrayList<URI>(locations.size());
            for (URI location : locations) {
                Long timeout = (Long)blocklist.get(location);
                if (timeout != null && time < (timeout & 0xFFFFFFFFFFFF8000L) || context.hasTransientlyFailed(location)) continue;
                updated.add(location);
            }
            locations = updated;
        }
        URI location = null;
        if (locations.size() < 1) {
            this.throwNoMoreDestinationsException(context);
        } else {
            location = locations.size() == 1 ? locations.get(0) : locations.get(ThreadLocalRandom.current().nextInt(locations.size()));
        }
        if (context != null) {
            context.setCurrentDestination(location);
        }
        return this.getPeerIdentityForNaming(location);
    }

    default public void throwNoMoreDestinationsException(RetryContext context) throws NamingException {
        if (context == null) {
            throw Messages.log.noMoreDestinations();
        }
        if (context.hasExplicitFailure()) {
            Throwable throwable = context.getFailures().get(0);
            try {
                throw throwable;
            }
            catch (Error | RuntimeException | NamingException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        ProviderEnvironment env = this.getProviderEnvironment();
        int blocklisted = env.getBlocklist().size();
        int transientlyFailed = context.transientFailCount();
        ExhaustedDestinationsException exception = Messages.log.noMoreDestinations(blocklisted, transientlyFailed);
        for (Throwable failure : context.getFailures()) {
            exception.addSuppressed(failure);
        }
        StackTraceElement[] stackTrace = exception.getStackTrace();
        exception.setStackTrace(Arrays.copyOfRange(stackTrace, 1, stackTrace.length - 1));
        throw exception;
    }

    public PeerIdentity getPeerIdentityForNaming(URI var1) throws NamingException;

    public static NamingProvider getCurrentNamingProvider() {
        return CurrentNamingProvider.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, U, R> R performAction(BiFunction<T, U, R> function, T arg1, U arg2) {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            R r = function.apply(arg1, arg2);
            return r;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, U, R, E extends Exception> R performExceptionAction(ExceptionBiFunction<T, U, R, E> function, T arg1, U arg2) throws E {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            Object object = function.apply(arg1, arg2);
            return (R)object;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, R> R performExceptionAction(NamingOperation<T, R> function, RetryContext contextOrNull, Name name, T param) throws NamingException {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            R r = function.apply(contextOrNull, name, param);
            return r;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    @Override
    default public void close() throws NamingException {
    }
}

