/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.listener;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.util.concurrent.CompletableFutures;

@Listener(observation=Listener.Observation.POST)
public class PostActivateListener<K, V> {
    private final BiConsumer<K, V> consumer;
    private final Executor executor;

    public PostActivateListener(BiConsumer<K, V> consumer, Executor executor) {
        this.consumer = consumer;
        this.executor = executor;
    }

    @CacheEntryActivated
    public CompletionStage<Void> activated(CacheEntryActivatedEvent<K, V> event) {
        if (!event.isPre()) {
            try {
                return CompletableFuture.runAsync(() -> this.consumer.accept(event.getKey(), event.getValue()), this.executor);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }
}

