/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.affinity.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.infinispan.affinity.impl.ConsistentHashKeyRegistry;

public class ConsistentHashKeyRegistryTestCase {
    @Test
    public void test() {
        ConsistentHash hash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        Predicate filter = (Predicate)Mockito.mock(Predicate.class);
        Supplier queueFactory = (Supplier)Mockito.mock(Supplier.class);
        Address local = (Address)Mockito.mock(Address.class);
        Address filtered = (Address)Mockito.mock(Address.class);
        Address standby = (Address)Mockito.mock(Address.class);
        BlockingQueue queue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        Mockito.when((Object)hash.getMembers()).thenReturn(Arrays.asList(local, filtered, standby));
        Mockito.when((Object)filter.test(local)).thenReturn((Object)true);
        Mockito.when((Object)filter.test(filtered)).thenReturn((Object)false);
        Mockito.when((Object)filter.test(standby)).thenReturn((Object)true);
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(local)).thenReturn(Collections.singleton(1));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(standby)).thenReturn(Collections.emptySet());
        Mockito.when((Object)((BlockingQueue)queueFactory.get())).thenReturn((Object)queue);
        ConsistentHashKeyRegistry registry = new ConsistentHashKeyRegistry(hash, filter, queueFactory);
        Assert.assertTrue((boolean)registry.getAddresses().contains(local));
        Assert.assertFalse((boolean)registry.getAddresses().contains(filtered));
        Assert.assertFalse((boolean)registry.getAddresses().contains(standby));
        Assert.assertEquals(Collections.singleton(local), (Object)registry.getAddresses());
        Assert.assertSame((Object)queue, (Object)registry.getKeys(local));
        Assert.assertNull((Object)registry.getKeys(standby));
        Assert.assertNull((Object)registry.getKeys(filtered));
    }
}

