/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LsHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue nodePath;
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l");

    public LsHandler() {
        this("ls");
    }

    public LsHandler(String command) {
        super(command, true);
        this.nodePath = new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, 0, "--node-path");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ModelNode outcome;
        String[] additionalProps;
        OperationRequestAddress.Node node;
        Iterator iterator;
        DefaultOperationRequestAddress address;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String nodePath = this.nodePath.getValue(parsedCmd);
        if (nodePath != null) {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
            DefaultCallbackHandler handler = new DefaultCallbackHandler(address);
            nodePath = ctx.getArgumentsString();
            if (this.l.isPresent(parsedCmd)) {
                nodePath = (nodePath = nodePath.trim()).startsWith("-l ") ? nodePath.substring(3) : nodePath.substring(0, nodePath.length() - 3);
            }
            ctx.getCommandLineParser().parse(nodePath, handler);
        } else {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
        }
        List<String> names = null;
        if (address.endsOnType()) {
            String type = address.getNodeType();
            address.toParentNode();
            names = Util.getNodeNames(ctx.getModelControllerClient(), address, type);
            this.printList(ctx, names, this.l.isPresent(parsedCmd));
            return;
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelNode typesRequest = new ModelNode();
        typesRequest.get("operation").set("read-children-types");
        ModelNode addressNode = typesRequest.get("address");
        if (address.isEmpty()) {
            addressNode.setEmptyList();
        } else {
            iterator = address.iterator();
            while (iterator.hasNext()) {
                node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    addressNode.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("Expected a node name for type '" + node.getType() + "' in path '" + ctx.getNodePathFormatter().format(address) + "'");
            }
        }
        steps.add(typesRequest);
        ModelNode resourceRequest = new ModelNode();
        resourceRequest.get("operation").set("read-resource");
        addressNode = resourceRequest.get("address");
        if (address.isEmpty()) {
            addressNode.setEmptyList();
        } else {
            iterator = address.iterator();
            while (iterator.hasNext()) {
                node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    addressNode.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("Expected a node name for type '" + node.getType() + "' in path '" + ctx.getNodePathFormatter().format(address) + "'");
            }
        }
        resourceRequest.get("include-runtime").set("true");
        steps.add(resourceRequest);
        if (this.l.isPresent(parsedCmd)) {
            steps.add(Util.buildRequest(ctx, address, "read-resource-description"));
            Set<String> argNames = parsedCmd.getPropertyNames();
            if (argNames.size() > 1) {
                additionalProps = new String[argNames.size() - 1];
                int i = 0;
                for (String arg : argNames) {
                    if (arg.equals(this.l.getFullName())) continue;
                    String prop = arg.length() > 1 && arg.charAt(0) == '-' ? (arg.charAt(1) == '-' ? arg.substring(2) : arg.substring(1)) : arg;
                    additionalProps[i++] = prop;
                }
            } else {
                additionalProps = null;
            }
        } else {
            additionalProps = null;
        }
        try {
            outcome = ctx.getModelControllerClient().execute(composite);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to read resource: " + e.getLocalizedMessage(), e);
        }
        if (!Util.isSuccess(outcome)) throw new CommandFormatException("Failed to fetch the list of children: " + outcome);
        if (outcome.hasDefined("result")) {
            ModelNode resultNode = outcome.get("result");
            ModelNode attrDescriptions = null;
            ModelNode childDescriptions = null;
            if (resultNode.hasDefined("step-3")) {
                ModelNode stepOutcome = resultNode.get("step-3");
                if (!Util.isSuccess(stepOutcome)) throw new CommandFormatException("Failed to get resource description: " + outcome);
                if (!stepOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-resource-description request: " + outcome);
                ModelNode descrResult = stepOutcome.get("result");
                if (descrResult.hasDefined("attributes")) {
                    attrDescriptions = descrResult.get("attributes");
                }
                if (descrResult.hasDefined("children")) {
                    childDescriptions = descrResult.get("children");
                }
            }
            ArrayList<String> typeNames = null;
            if (!resultNode.hasDefined("step-1")) throw new CommandFormatException("The result for children type names is not available: " + outcome);
            ModelNode typesOutcome = resultNode.get("step-1");
            if (!Util.isSuccess(typesOutcome)) throw new CommandFormatException("Failed to fetch type names: " + outcome);
            if (!typesOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-children-types request: " + outcome);
            ModelNode resourceResult = typesOutcome.get("result");
            List types = resourceResult.asList();
            if (!types.isEmpty()) {
                typeNames = new ArrayList<String>();
                for (ModelNode type : types) {
                    typeNames.add(type.asString());
                }
                if (childDescriptions == null && attrDescriptions == null) {
                    names = typeNames;
                }
            }
            if (!resultNode.hasDefined("step-2")) throw new CommandFormatException("The result for attributes is not available: " + outcome);
            ModelNode resourceOutcome = resultNode.get("step-2");
            if (!Util.isSuccess(resourceOutcome)) throw new CommandFormatException("Failed to fetch attributes: " + outcome);
            if (!resourceOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-resource request: " + outcome);
            resourceResult = resourceOutcome.get("result");
            List props = resourceResult.asPropertyList();
            if (!props.isEmpty()) {
                SimpleTable childrenTable;
                SimpleTable attrTable;
                if (attrDescriptions == null) {
                    attrTable = null;
                } else if (additionalProps != null) {
                    String[] headers = new String[3 + additionalProps.length];
                    headers[0] = "ATTRIBUTE";
                    headers[1] = "VALUE";
                    headers[2] = "TYPE";
                    int i = 3;
                    for (String additional : additionalProps) {
                        headers[i++] = additional.toUpperCase(Locale.ENGLISH);
                    }
                    attrTable = new SimpleTable(headers);
                } else {
                    attrTable = new SimpleTable(new String[]{"ATTRIBUTE", "VALUE", "TYPE"});
                }
                SimpleTable simpleTable = childrenTable = childDescriptions == null ? null : new SimpleTable(new String[]{"CHILD", "MIN-OCCURS", "MAX-OCCURS"});
                if (typeNames == null && attrTable == null && childrenTable == null) {
                    typeNames = new ArrayList();
                    names = typeNames;
                }
                for (Property prop : props) {
                    StringBuilder buf = new StringBuilder();
                    if (typeNames == null || !typeNames.contains(prop.getName())) {
                        if (attrDescriptions == null) {
                            buf.append(prop.getName());
                            buf.append('=');
                            buf.append(prop.getValue().asString());
                            typeNames.add(buf.toString());
                            buf.setLength(0);
                            continue;
                        }
                        String[] line = new String[attrTable.columnsTotal()];
                        line[0] = prop.getName();
                        line[1] = prop.getValue().asString();
                        if (attrDescriptions.hasDefined(prop.getName())) {
                            ModelNode attrDescr = attrDescriptions.get(prop.getName());
                            line[2] = this.getAsString(attrDescr, "type");
                            if (additionalProps != null) {
                                int i = 3;
                                for (String additional : additionalProps) {
                                    line[i++] = this.getAsString(attrDescr, additional);
                                }
                            }
                        } else {
                            for (int i = 2; i < line.length; ++i) {
                                line[i] = "n/a";
                            }
                        }
                        attrTable.addLine(line);
                        continue;
                    }
                    if (childDescriptions == null) continue;
                    if (childDescriptions.hasDefined(prop.getName())) {
                        ModelNode childDescr = childDescriptions.get(prop.getName());
                        Integer maxOccurs = this.getAsInteger(childDescr, "max-occurs");
                        childrenTable.addLine(new String[]{prop.getName(), this.getAsString(childDescr, "min-occurs"), maxOccurs == null ? "n/a" : (maxOccurs == Integer.MAX_VALUE ? "unbounded" : maxOccurs.toString())});
                        continue;
                    }
                    childrenTable.addLine(new String[]{prop.getName(), "n/a", "n/a"});
                }
                StringBuilder buf = null;
                if (attrTable != null && !attrTable.isEmpty()) {
                    buf = new StringBuilder();
                    attrTable.append(buf, true);
                }
                if (childrenTable != null && !childrenTable.isEmpty()) {
                    if (buf == null) {
                        buf = new StringBuilder();
                    } else {
                        buf.append("\n\n");
                    }
                    childrenTable.append(buf, true);
                }
                if (buf != null) {
                    ctx.printLine(buf.toString());
                }
            }
        }
        if (names == null) return;
        this.printList(ctx, names, this.l.isPresent(parsedCmd));
    }

    protected String getAsString(ModelNode attrDescr, String name) {
        if (attrDescr == null) {
            return "n/a";
        }
        return attrDescr.has(name) ? attrDescr.get(name).asString() : "n/a";
    }

    protected Integer getAsInteger(ModelNode attrDescr, String name) {
        if (attrDescr == null) {
            return null;
        }
        return attrDescr.has(name) ? Integer.valueOf(attrDescr.get(name).asInt()) : null;
    }
}

