/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdClaims;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.servlet.HttpStorageController;
import org.wildfly.security.soteria.original.AuthenticationController;
import org.wildfly.security.soteria.original.JsonClaims;
import org.wildfly.security.soteria.original.UserInfoController;

@SessionScoped
public class OpenIdContextImpl
implements OpenIdContext {
    private static final long serialVersionUID = 1L;
    private String tokenType;
    private AccessToken accessToken;
    private IdentityToken identityToken;
    private RefreshToken refreshToken;
    private Long expiresIn;
    private JsonObject claims;
    @Inject
    private UserInfoController userInfoController;
    @Inject
    private OpenIdConfiguration configuration;
    @Inject
    private AuthenticationController authenticationController;

    public String getSubject() {
        return this.getIdentityToken().getJwtClaims().getSubject().orElse(null);
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken token) {
        this.accessToken = token;
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    public Optional<RefreshToken> getRefreshToken() {
        return Optional.ofNullable(this.refreshToken);
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Optional<Long> getExpiresIn() {
        return Optional.ofNullable(this.expiresIn);
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public JsonObject getClaimsJson() {
        if (this.claims == null) {
            this.claims = this.configuration != null && this.accessToken != null ? this.userInfoController.getUserInfo(this.configuration, this.accessToken) : Json.createObjectBuilder().build();
        }
        return this.claims;
    }

    public OpenIdClaims getClaims() {
        return new JsonClaims(this.getClaimsJson());
    }

    public JsonObject getProviderMetadata() {
        return this.configuration.getProviderMetadata().getDocument();
    }

    public <T> Optional<T> getStoredValue(HttpServletRequest request, HttpServletResponse response, String key) {
        return HttpStorageController.getInstance((OpenIdConfiguration)this.configuration, (HttpServletRequest)request, (HttpServletResponse)response).get(key);
    }
}

