/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron.ProviderAttributeDefinition;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

final class KeyStoreDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<KeyStore> KEY_STORE_UTIL = ServiceUtil.newInstance(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, "key-store", KeyStore.class);
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, false).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAttributeGroup("implementation")).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-store", true)).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeDefinition((boolean)true);
    static final SimpleAttributeDefinition REQUIRED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("required", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setAttributeGroup("file")).setRequires(new String[]{"path"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ALIAS_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("key-store");
    private static final SimpleAttributeDefinition SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("size", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition MODIFIED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("modified", ModelType.BOOLEAN).setStorageRuntime()).build();
    private static final SimpleOperationDefinition LOAD = new SimpleOperationDefinitionBuilder("load", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build();
    private static final SimpleOperationDefinition STORE = new SimpleOperationDefinitionBuilder("store", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build();
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{TYPE, PROVIDER_NAME, PROVIDERS, CREDENTIAL_REFERENCE, FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO, REQUIRED, ALIAS_FILTER};
    private static final KeyStoreAddHandler ADD = new KeyStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    private static final AbstractWriteAttributeHandler WRITE = new ElytronReloadRequiredWriteAttributeHandler(CONFIG_ATTRIBUTES);

    KeyStoreDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"key-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

                protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName keyStoreName = KEY_STORE_UTIL.serviceName(operation);
                    ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(keyStoreName);
                    ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SIZE, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                    try {
                        result.set(keyStoreService.getValue().size());
                    }
                    catch (KeyStoreException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessKeyStore(e);
                    }
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SYNCHRONIZED, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    result.set(sdf.format(new Date(keyStoreService.timeSynched())));
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MODIFIED, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                    result.set(keyStoreService.isModified());
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ProviderAttributeDefinition.LOADED_PROVIDER, (OperationStepHandler)new KeyStoreRuntimeOnlyHandler(false){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
                    ProviderAttributeDefinition.populateProvider(result, keyStoreService.getValue().getProvider(), false);
                }
            });
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)LOAD, (OperationStepHandler)PersistanceHandler.INSTANCE);
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerOperationHandler((OperationDefinition)STORE, (OperationStepHandler)PersistanceHandler.INSTANCE);
        }
    }

    private static class PersistanceHandler
    extends KeyStoreRuntimeOnlyHandler {
        private static final PersistanceHandler INSTANCE = new PersistanceHandler();

        private PersistanceHandler() {
            super(true, true);
        }

        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, final KeyStoreService keyStoreService) throws OperationFailedException {
            String operationName;
            switch (operationName = operation.require("operation").asString()) {
                case "load": {
                    final KeyStoreService.LoadKey loadKey = keyStoreService.load();
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            keyStoreService.revertLoad(loadKey);
                        }
                    });
                    break;
                }
                case "store": {
                    keyStoreService.save();
                    break;
                }
                default: {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidOperationName(operationName, "load", "store");
                }
            }
        }
    }

    static abstract class KeyStoreRuntimeOnlyHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean serviceMustBeUp;
        private final boolean writeAccess;

        KeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp, boolean writeAccess) {
            this.serviceMustBeUp = serviceMustBeUp;
            this.writeAccess = writeAccess;
        }

        KeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp) {
            this(serviceMustBeUp, false);
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName keyStoreName = KEY_STORE_UTIL.serviceName(operation);
            ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(this.writeAccess), keyStoreName, KeyStore.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                if (this.serviceMustBeUp) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(keyStoreName, serviceState);
                }
                return;
            }
            this.performRuntime(context.getResult(), context, operation, (KeyStoreService)serviceContainer.getService());
        }

        protected void performRuntime(ModelNode result, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
        }

        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, KeyStoreService keyStoreService) throws OperationFailedException {
            this.performRuntime(result, operation, keyStoreService);
        }
    }

    private static class KeyStoreAddHandler
    extends BaseAddHandler {
        private KeyStoreAddHandler() {
            super(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            KeyStoreService keyStoreService;
            ModelNode model = resource.getModel();
            String providers = PROVIDERS.resolveModelAttribute(context, model).asStringOrNull();
            String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
            String type = TYPE.resolveModelAttribute(context, model).asString();
            String path = FileAttributeDefinitions.PATH.resolveModelAttribute(context, model).asStringOrNull();
            String relativeTo = null;
            String aliasFilter = ALIAS_FILTER.resolveModelAttribute(context, model).asStringOrNull();
            if (path != null) {
                relativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
                boolean required = REQUIRED.resolveModelAttribute(context, model).asBoolean();
                keyStoreService = KeyStoreService.createFileBasedKeyStoreService(providerName, type, relativeTo, path, required, aliasFilter);
            } else {
                keyStoreService = KeyStoreService.createFileLessKeyStoreService(providerName, type, aliasFilter);
            }
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(KeyStore.class);
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)keyStoreService).setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, keyStoreService.getPathManagerInjector());
            if (relativeTo != null) {
                serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
            }
            if (providers != null) {
                String providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providers);
                ServiceName providerLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                serviceBuilder.addDependency(providerLoaderServiceName, Provider[].class, keyStoreService.getProvidersInjector());
            }
            keyStoreService.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)serviceBuilder));
            ElytronDefinition.commonDependencies(serviceBuilder).install();
        }
    }
}

