/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.Closeable;
import java.io.IOException;
import org.wikidata.wdtk.datamodel.implementation.EntityIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.FormIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.GlobeCoordinatesValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.MonolingualTextValueImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.QuantityValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.StringValueImpl;
import org.wikidata.wdtk.datamodel.implementation.TimeValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.Value;

@JsonDeserialize(using=JacksonDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ValueImpl
implements Value {
    public static final String JSON_VALUE_TYPE_STRING = "string";
    public static final String JSON_VALUE_TYPE_TIME = "time";
    public static final String JSON_VALUE_TYPE_GLOBE_COORDINATES = "globecoordinate";
    public static final String JSON_VALUE_TYPE_ENTITY_ID = "wikibase-entityid";
    public static final String JSON_VALUE_TYPE_QUANTITY = "quantity";
    public static final String JSON_VALUE_TYPE_MONOLINGUAL_TEXT = "monolingualtext";
    private final String type;

    public ValueImpl(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    static class JacksonDeserializer
    extends StdDeserializer<ValueImpl> {
        JacksonDeserializer() {
            super(ValueImpl.class);
        }

        public ValueImpl deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            ObjectCodec mapper = jsonParser.getCodec();
            JsonNode root = (JsonNode)mapper.readTree(jsonParser);
            Class<? extends ValueImpl> valueClass = this.getValueClass(root, jsonParser);
            return (ValueImpl)mapper.treeToValue((TreeNode)root, valueClass);
        }

        private Class<? extends ValueImpl> getValueClass(JsonNode jsonNode, JsonParser jsonParser) throws JsonMappingException {
            String jsonType;
            switch (jsonType = jsonNode.get("type").asText()) {
                case "wikibase-entityid": {
                    JsonNode valueNode = jsonNode.get("value");
                    if (valueNode != null) {
                        if (valueNode.has("entity-type")) {
                            try {
                                return this.getValueClassFromEntityType(valueNode.get("entity-type").asText());
                            }
                            catch (IllegalArgumentException e) {
                                throw new JsonMappingException((Closeable)jsonParser, e.getMessage(), (Throwable)e);
                            }
                        }
                        if (valueNode.has("id")) {
                            try {
                                return this.getValueClassFromEntityType(EntityIdValueImpl.guessEntityTypeFromId(valueNode.get("id").asText()));
                            }
                            catch (IllegalArgumentException e) {
                                throw new JsonMappingException((Closeable)jsonParser, e.getMessage(), (Throwable)e);
                            }
                        }
                        throw new JsonMappingException((Closeable)jsonParser, "Unexpected entity id serialization");
                    }
                }
                case "string": {
                    return StringValueImpl.class;
                }
                case "time": {
                    return TimeValueImpl.class;
                }
                case "globecoordinate": {
                    return GlobeCoordinatesValueImpl.class;
                }
                case "quantity": {
                    return QuantityValueImpl.class;
                }
                case "monolingualtext": {
                    return MonolingualTextValueImpl.class;
                }
            }
            throw new JsonMappingException((Closeable)jsonParser, "Property values of type \"" + jsonType + "\" are not supported yet.");
        }

        private Class<? extends ValueImpl> getValueClassFromEntityType(String entityType) {
            switch (entityType) {
                case "item": {
                    return ItemIdValueImpl.class;
                }
                case "lexeme": {
                    return LexemeIdValueImpl.class;
                }
                case "property": {
                    return PropertyIdValueImpl.class;
                }
                case "form": {
                    return FormIdValueImpl.class;
                }
                case "sense": {
                    return SenseIdValueImpl.class;
                }
            }
            throw new IllegalArgumentException("Entities of type \"" + entityType + "\" are not supported.");
        }
    }
}

