/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TermImpl
implements MonolingualTextValue {
    private final String languageCode;
    private final String text;

    @JsonCreator
    public TermImpl(@JsonProperty(value="language") String languageCode, @JsonProperty(value="value") String text) {
        Validate.notNull((Object)languageCode, (String)"A language has to be provided to create a MonolingualTextValue", (Object[])new Object[0]);
        this.languageCode = languageCode;
        Validate.notNull((Object)text, (String)"A text has to be provided to create a MonolingualTextValue", (Object[])new Object[0]);
        this.text = text;
    }

    @Deprecated
    public TermImpl(MonolingualTextValue mltv) {
        this(mltv.getLanguageCode(), mltv.getText());
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    @Override
    @JsonProperty(value="value")
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="language")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsMonolingualTextValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

