/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ClaimImpl;
import org.wikidata.wdtk.datamodel.implementation.ReferenceImpl;
import org.wikidata.wdtk.datamodel.implementation.SnakGroupImpl;
import org.wikidata.wdtk.datamodel.implementation.SnakImpl;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.util.NestedIterator;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class StatementImpl
implements Statement {
    private final String statementId;
    private final StatementRank rank;
    private final Snak mainSnak;
    private final Map<String, List<Snak>> qualifiers;
    private final List<String> qualifiersOrder;
    private final EntityIdValue subjectId;
    private final List<Reference> references;
    private List<SnakGroup> qualifiersGroups;

    public StatementImpl(String statementId, StatementRank rank, Snak mainSnak, List<SnakGroup> qualifiers, List<Reference> references, EntityIdValue subjectId) {
        this.statementId = statementId == null ? "" : statementId;
        Validate.notNull((Object)((Object)rank), (String)"No rank provided to create a statement.", (Object[])new Object[0]);
        this.rank = rank;
        Validate.notNull((Object)mainSnak, (String)"No main snak provided to create a statement.", (Object[])new Object[0]);
        this.mainSnak = mainSnak;
        this.qualifiers = new HashMap<String, List<Snak>>();
        this.qualifiersOrder = new ArrayList<String>();
        for (SnakGroup qualifiersGroup : qualifiers) {
            this.qualifiers.put(qualifiersGroup.getProperty().getId(), qualifiersGroup.getSnaks());
            this.qualifiersOrder.add(qualifiersGroup.getProperty().getId());
        }
        this.references = references == null ? Collections.emptyList() : references;
        Validate.notNull((Object)subjectId);
        this.subjectId = subjectId;
    }

    public StatementImpl(String statementId, StatementRank rank, Snak mainSnak, Map<String, List<Snak>> qualifiers, List<String> qualifiersOrder, List<Reference> references, EntityIdValue subjectId) {
        this.statementId = statementId == null ? "" : statementId;
        Validate.notNull((Object)((Object)rank), (String)"No rank provided to create a statement.", (Object[])new Object[0]);
        this.rank = rank;
        Validate.notNull((Object)mainSnak, (String)"No main snak provided to create a statement.", (Object[])new Object[0]);
        this.mainSnak = mainSnak;
        this.qualifiers = qualifiers == null ? Collections.emptyMap() : qualifiers;
        this.qualifiersOrder = qualifiersOrder == null ? Collections.emptyList() : qualifiersOrder;
        this.references = references == null ? Collections.emptyList() : references;
        Validate.notNull((Object)subjectId);
        this.subjectId = subjectId;
    }

    public StatementImpl(String statementId, Snak mainsnak, EntityIdValue subjectId) {
        this(statementId, StatementRank.NORMAL, mainsnak, null, null, null, subjectId);
    }

    @JsonProperty(value="type")
    String getJsonType() {
        return "statement";
    }

    @Override
    @JsonIgnore
    public Claim getClaim() {
        return new ClaimImpl(this);
    }

    @Override
    @JsonIgnore
    public EntityIdValue getSubject() {
        return this.subjectId;
    }

    @Override
    @JsonProperty(value="mainsnak")
    public Snak getMainSnak() {
        return this.mainSnak;
    }

    @Override
    @JsonIgnore
    public List<SnakGroup> getQualifiers() {
        if (this.qualifiersGroups == null) {
            this.qualifiersGroups = SnakGroupImpl.makeSnakGroups(this.qualifiers, this.qualifiersOrder);
        }
        return this.qualifiersGroups;
    }

    @Override
    @JsonIgnore
    public Iterator<Snak> getAllQualifiers() {
        return new NestedIterator(this.getQualifiers());
    }

    @JsonProperty(value="qualifiers")
    Map<String, List<Snak>> getJsonQualifiers() {
        return Collections.unmodifiableMap(this.qualifiers);
    }

    @JsonProperty(value="qualifiers-order")
    List<String> getQualifiersOrder() {
        return Collections.unmodifiableList(this.qualifiersOrder);
    }

    @Override
    @JsonSerialize(using=StatementRankSerializer.class)
    public StatementRank getRank() {
        return this.rank;
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    @JsonProperty(value="id")
    public String getStatementId() {
        return this.statementId;
    }

    @Override
    public Value getValue() {
        return this.mainSnak.getValue();
    }

    @Override
    public Statement withStatementId(String id) {
        return new StatementImpl(id, this.getRank(), this.getMainSnak(), this.getQualifiers(), this.getReferences(), this.getSubject());
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsStatement(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    static class StatementRankDeserializer
    extends JsonDeserializer<StatementRank> {
        StatementRankDeserializer() {
        }

        public StatementRank deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return StatementRank.valueOf(jp.getText().toUpperCase());
        }
    }

    static class StatementRankSerializer
    extends JsonSerializer<StatementRank> {
        StatementRankSerializer() {
        }

        public void serialize(StatementRank value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name().toLowerCase());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PreStatement {
        private final String statementId;
        private final StatementRank rank;
        private final List<Reference> references;
        private final Snak mainSnak;
        private final Map<String, List<Snak>> qualifiers;
        private final List<String> qualifiersOrder;

        private PreStatement(String statementId, StatementRank rank, Snak mainsnak, Map<String, List<Snak>> qualifiers, List<String> qualifiersOrder, List<Reference> references) {
            this.statementId = statementId;
            this.rank = rank;
            this.mainSnak = mainsnak;
            this.qualifiers = qualifiers;
            this.qualifiersOrder = qualifiersOrder;
            this.references = references;
        }

        @JsonCreator
        static PreStatement fromJson(@JsonProperty(value="id") String id, @JsonProperty(value="rank") @JsonDeserialize(using=StatementRankDeserializer.class) StatementRank rank, @JsonProperty(value="mainsnak") SnakImpl mainsnak, @JsonProperty(value="qualifiers") Map<String, List<SnakImpl>> qualifiers, @JsonProperty(value="qualifiers-order") List<String> qualifiersOrder, @JsonProperty(value="references") @JsonDeserialize(contentAs=ReferenceImpl.class) List<Reference> references) {
            if (qualifiers == null) {
                qualifiers = Collections.emptyMap();
            }
            HashMap<String, List<Snak>> newQualifiers = new HashMap<String, List<Snak>>(qualifiers.size());
            for (Map.Entry<String, List<SnakImpl>> entry : qualifiers.entrySet()) {
                ArrayList snaks = new ArrayList(entry.getValue());
                newQualifiers.put(entry.getKey(), snaks);
            }
            return new PreStatement(id, rank, mainsnak, newQualifiers, qualifiersOrder, references);
        }

        public StatementImpl withSubject(EntityIdValue subjectId) {
            return new StatementImpl(this.statementId, this.rank, this.mainSnak, this.qualifiers, this.qualifiersOrder, this.references, subjectId);
        }
    }
}

