/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Sites;

public class SitesImpl
implements Sites {
    public static String DEFAULT_PROTOCOL_PREFIX = "https:";
    final HashMap<String, SiteInformation> sites = new HashMap();

    @Override
    public void setSiteInformation(String siteKey, String group, String languageCode, String siteType, String filePath, String pagePath) {
        this.sites.put(siteKey, new SiteInformation(siteKey, group, languageCode, siteType, filePath, pagePath));
    }

    @Override
    public String getLanguageCode(String siteKey) {
        if (this.sites.containsKey(siteKey)) {
            return this.sites.get((Object)siteKey).languageCode;
        }
        return null;
    }

    @Override
    public String getGroup(String siteKey) {
        if (this.sites.containsKey(siteKey)) {
            return this.sites.get((Object)siteKey).group;
        }
        return null;
    }

    @Override
    public String getPageUrl(String siteKey, String pageTitle) {
        if (this.sites.containsKey(siteKey)) {
            return this.sites.get(siteKey).getPageUrl(pageTitle);
        }
        return null;
    }

    @Override
    public String getSiteLinkUrl(SiteLink siteLink) {
        return this.getPageUrl(siteLink.getSiteKey(), siteLink.getPageTitle());
    }

    @Override
    public String getFileUrl(String siteKey, String fileName) {
        if (this.sites.containsKey(siteKey)) {
            return this.sites.get(siteKey).getFileUrl(fileName);
        }
        return null;
    }

    @Override
    public String getSiteType(String siteKey) {
        if (this.sites.containsKey(siteKey)) {
            return this.sites.get((Object)siteKey).siteType;
        }
        return null;
    }

    class SiteInformation {
        final String siteKey;
        final String group;
        final String languageCode;
        final String siteType;
        final String filePathPre;
        final String filePathPost;
        final String pagePathPre;
        final String pagePathPost;

        SiteInformation(String siteKey, String group, String languageCode, String siteType, String filePath, String pagePath) {
            Validate.notNull((Object)siteKey, (String)"Site key must not be null.", (Object[])new Object[0]);
            Validate.notNull((Object)group, (String)"Group must not be null.", (Object[])new Object[0]);
            Validate.notNull((Object)languageCode, (String)"Language code must not be null.", (Object[])new Object[0]);
            Validate.notNull((Object)siteType, (String)"Site type must not be null.", (Object[])new Object[0]);
            Validate.notNull((Object)filePath, (String)"File path must not be null.", (Object[])new Object[0]);
            Validate.notNull((Object)pagePath, (String)"Page path must not be null.", (Object[])new Object[0]);
            this.siteKey = siteKey;
            this.group = group;
            this.languageCode = languageCode;
            this.siteType = siteType;
            filePath = this.addProtocolPrefix(filePath);
            pagePath = this.addProtocolPrefix(pagePath);
            int iFileName = filePath.indexOf("$1");
            this.filePathPre = filePath.substring(0, iFileName);
            this.filePathPost = filePath.substring(iFileName + 2, filePath.length());
            int iPageName = pagePath.indexOf("$1");
            this.pagePathPre = pagePath.substring(0, iPageName);
            this.pagePathPost = pagePath.substring(iPageName + 2, pagePath.length());
        }

        String getFileUrl(String fileName) {
            return this.filePathPre + fileName + this.filePathPost;
        }

        String getPageUrl(String pageTitle) {
            try {
                String encodedTitle;
                if ("mediawiki".equals(this.siteType)) {
                    encodedTitle = URLEncoder.encode(pageTitle.replace(" ", "_"), "utf-8");
                    encodedTitle = encodedTitle.replace("%3A", ":").replace("%2F", "/");
                } else {
                    encodedTitle = URLEncoder.encode(pageTitle, "utf-8");
                }
                return this.pagePathPre + encodedTitle + this.pagePathPost;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Your JRE does not support UTF-8 encoding. Srsly?!", e);
            }
        }

        String addProtocolPrefix(String urlPrefix) {
            if ("//".equals(urlPrefix.substring(0, 2))) {
                return DEFAULT_PROTOCOL_PREFIX + urlPrefix;
            }
            return urlPrefix;
        }
    }
}

