/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.FormDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LexemeDocumentImpl
extends StatementDocumentImpl
implements LexemeDocument {
    private ItemIdValue lexicalCategory;
    private ItemIdValue language;
    private Map<String, MonolingualTextValue> lemmas;
    private List<FormDocument> forms;
    private List<SenseDocument> senses;

    LexemeDocumentImpl(LexemeIdValue id, ItemIdValue lexicalCategory, ItemIdValue language, List<MonolingualTextValue> lemmas, List<StatementGroup> statements, List<FormDocument> forms, List<SenseDocument> senses, long revisionId) {
        super((EntityIdValue)id, statements, revisionId);
        Validate.notNull((Object)lexicalCategory, (String)"Lexeme lexical category should not be null", (Object[])new Object[0]);
        this.lexicalCategory = lexicalCategory;
        Validate.notNull((Object)language, (String)"Lexeme language should not be null", (Object[])new Object[0]);
        this.language = language;
        Validate.notNull(lemmas, (String)"Lexeme lemmas should not be null", (Object[])new Object[0]);
        if (lemmas.isEmpty()) {
            throw new IllegalArgumentException("Lexemes should have at least one lemma");
        }
        this.lemmas = LexemeDocumentImpl.constructTermMap(lemmas);
        this.forms = forms == null ? Collections.emptyList() : forms;
        this.senses = senses == null ? Collections.emptyList() : senses;
    }

    @JsonCreator
    LexemeDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="lexicalCategory") String lexicalCategory, @JsonProperty(value="language") String language, @JsonProperty(value="lemmas") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> lemmas, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="forms") @JsonDeserialize(contentAs=FormDocumentImpl.class) List<FormDocument> forms, @JsonProperty(value="senses") @JsonDeserialize(contentAs=SenseDocumentImpl.class) List<SenseDocument> senses, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, claims, revisionId, siteIri);
        Validate.notNull((Object)lexicalCategory, (String)"Lexeme lexical category should not be null", (Object[])new Object[0]);
        this.lexicalCategory = new ItemIdValueImpl(lexicalCategory, siteIri);
        Validate.notNull((Object)language, (String)"Lexeme language should not be null", (Object[])new Object[0]);
        this.language = new ItemIdValueImpl(language, siteIri);
        Validate.notNull(lemmas, (String)"Lexeme lemmas should not be null", (Object[])new Object[0]);
        if (lemmas.isEmpty()) {
            throw new IllegalArgumentException("Lexemes should have at least one lemma");
        }
        this.lemmas = lemmas;
        this.forms = forms == null ? Collections.emptyList() : forms;
        this.senses = senses == null ? Collections.emptyList() : senses;
    }

    private LexemeDocumentImpl(LexemeIdValue id, ItemIdValue lexicalCategory, ItemIdValue language, Map<String, MonolingualTextValue> lemmas, Map<String, List<Statement>> statements, List<FormDocument> forms, long revisionId) {
        super((EntityIdValue)id, statements, revisionId);
        this.lexicalCategory = lexicalCategory;
        this.language = language;
        this.lemmas = lemmas;
        this.forms = forms;
    }

    private static Map<String, MonolingualTextValue> constructTermMap(List<MonolingualTextValue> terms) {
        HashMap<String, MonolingualTextValue> map = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue term : terms) {
            String language = term.getLanguageCode();
            if (map.containsKey(language)) {
                throw new IllegalArgumentException("Multiple terms provided for the same language.");
            }
            map.put(language, term instanceof TermImpl ? term : new TermImpl(term.getLanguageCode(), term.getText()));
        }
        return map;
    }

    @Override
    @JsonIgnore
    public LexemeIdValue getEntityId() {
        return new LexemeIdValueImpl(this.entityId, this.siteIri);
    }

    @Override
    @JsonIgnore
    public ItemIdValue getLexicalCategory() {
        return this.lexicalCategory;
    }

    @JsonProperty(value="lexicalCategory")
    String getJsonLexicalCategory() {
        return this.lexicalCategory.getId();
    }

    @Override
    @JsonIgnore
    public ItemIdValue getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    String getJsonLanguage() {
        return this.language.getId();
    }

    @Override
    @JsonProperty(value="lemmas")
    public Map<String, MonolingualTextValue> getLemmas() {
        return this.lemmas;
    }

    @Override
    @JsonProperty(value="forms")
    public List<FormDocument> getForms() {
        return this.forms;
    }

    @Override
    @JsonProperty(value="senses")
    public List<SenseDocument> getSenses() {
        return this.senses;
    }

    @Override
    @JsonIgnore
    public FormDocument getForm(FormIdValue formId) {
        for (FormDocument form : this.forms) {
            if (!form.getEntityId().equals(formId)) continue;
            return form;
        }
        throw new IndexOutOfBoundsException("There is no " + formId + " in the lexeme.");
    }

    @Override
    @JsonIgnore
    public SenseDocument getSense(SenseIdValue senseId) {
        for (SenseDocument sense : this.senses) {
            if (!sense.getEntityId().equals(senseId)) continue;
            return sense;
        }
        throw new IndexOutOfBoundsException("There is no " + senseId + " in the lexeme.");
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsLexemeDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public LexemeDocument withStatement(Statement statement) {
        Map<String, List<Statement>> newGroups = LexemeDocumentImpl.addStatementToGroups(statement, this.claims);
        return new LexemeDocumentImpl(this.getEntityId(), this.lexicalCategory, this.language, this.lemmas, newGroups, this.forms, this.revisionId);
    }

    @Override
    public LexemeDocument withoutStatementIds(Set<String> statementIds) {
        Map<String, List<Statement>> newGroups = LexemeDocumentImpl.removeStatements(statementIds, this.claims);
        return new LexemeDocumentImpl(this.getEntityId(), this.lexicalCategory, this.language, this.lemmas, newGroups, this.forms, this.revisionId);
    }

    @Override
    public LexemeDocument withRevisionId(long newRevisionId) {
        return new LexemeDocumentImpl(this.getEntityId(), this.lexicalCategory, this.language, this.lemmas, this.claims, this.forms, newRevisionId);
    }
}

