/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
public class GlobeCoordinatesValueImpl
extends ValueImpl
implements GlobeCoordinatesValue {
    private final JacksonInnerGlobeCoordinates value;

    public GlobeCoordinatesValueImpl(double latitude, double longitude, double precision, String globe) {
        super("globecoordinate");
        this.value = new JacksonInnerGlobeCoordinates(latitude, longitude, precision, globe);
    }

    @JsonCreator
    GlobeCoordinatesValueImpl(@JsonProperty(value="value") JacksonInnerGlobeCoordinates innerCoordinates) {
        super("globecoordinate");
        this.value = innerCoordinates;
    }

    public JacksonInnerGlobeCoordinates getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public double getLatitude() {
        return this.value.getLatitude();
    }

    @Override
    @JsonIgnore
    public double getLongitude() {
        return this.value.getLongitude();
    }

    @Override
    @JsonIgnore
    public double getPrecision() {
        return this.value.getPrecision();
    }

    @Override
    @JsonIgnore
    public String getGlobe() {
        return this.value.getGlobe();
    }

    @Override
    @JsonIgnore
    public ItemIdValue getGlobeItemId() {
        return ItemIdValueImpl.fromIri(this.value.getGlobe());
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsGlobeCoordinatesValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JacksonInnerGlobeCoordinates {
        private final double latitude;
        private final double longitude;
        private final double precision;
        private final String globe;

        @JsonCreator
        JacksonInnerGlobeCoordinates(@JsonProperty(value="latitude") double latitude, @JsonProperty(value="longitude") double longitude, @JsonProperty(value="precision") double precision, @JsonProperty(value="globe") String globe) {
            Validate.notNull((Object)globe, (String)"globe IRI must not be null", (Object[])new Object[0]);
            if (latitude > 90.0 || latitude < -90.0) {
                throw new IllegalArgumentException("Latitude must be between 90 degrees and -90 degrees.");
            }
            if (longitude > 360.0 || longitude < -360.0) {
                throw new IllegalArgumentException("Longitude must be between -360 degrees and +360 degrees.");
            }
            this.latitude = latitude;
            this.longitude = longitude;
            this.precision = precision <= 0.0 ? 2.777777777777778E-4 : precision;
            this.globe = globe;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public double getPrecision() {
            return this.precision;
        }

        public String getGlobe() {
            return this.globe;
        }
    }
}

