/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.FormDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ItemDocumentImpl.class, name="item"), @JsonSubTypes.Type(value=LexemeDocumentImpl.class, name="lexeme"), @JsonSubTypes.Type(value=FormDocumentImpl.class, name="form"), @JsonSubTypes.Type(value=SenseDocumentImpl.class, name="sense"), @JsonSubTypes.Type(value=PropertyDocumentImpl.class, name="property")})
public abstract class EntityDocumentImpl
implements EntityDocument {
    static final String JSON_TYPE_ITEM = "item";
    static final String JSON_TYPE_PROPERTY = "property";
    static final String JSON_TYPE_LEXEME = "lexeme";
    static final String JSON_TYPE_FORM = "form";
    static final String JSON_TYPE_SENSE = "sense";
    @JsonIgnore
    protected final String entityId;
    @JsonIgnore
    protected final String siteIri;
    @JsonIgnore
    protected final long revisionId;

    EntityDocumentImpl(EntityIdValue id, long revisionId) {
        Validate.notNull((Object)id);
        this.entityId = id.getId();
        this.siteIri = id.getSiteIri();
        this.revisionId = revisionId;
    }

    EntityDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        Validate.notNull((Object)jsonId);
        this.entityId = jsonId;
        Validate.notNull((Object)siteIri);
        this.siteIri = siteIri;
        this.revisionId = revisionId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="id")
    public String getJsonId() {
        if (!"http://localhost/entity/".equals(this.siteIri)) {
            return this.entityId;
        }
        return null;
    }

    @JsonIgnore
    public String getSiteIri() {
        return this.siteIri;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NonZeroFilter.class)
    @JsonProperty(value="lastrevid")
    public long getRevisionId() {
        return this.revisionId;
    }

    private static class NonZeroFilter {
        private NonZeroFilter() {
        }

        public boolean equals(Object other) {
            return other instanceof Long && (Long)other == 0L;
        }

        public int hashCode() {
            return 0;
        }
    }
}

