/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wikidata.wdtk.datamodel.helpers.AbstractDataObjectBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.Value;

public class StatementBuilder
extends AbstractDataObjectBuilder<StatementBuilder, Statement> {
    private final EntityIdValue subject;
    private final PropertyIdValue mainProperty;
    private Value mainValue = null;
    private boolean noMainValue = false;
    private final HashMap<PropertyIdValue, ArrayList<Snak>> qualifiers = new HashMap();
    private String statementId = "";
    private StatementRank rank = StatementRank.NORMAL;
    private final ArrayList<Reference> references = new ArrayList();

    protected StatementBuilder(EntityIdValue subject, PropertyIdValue property) {
        this.subject = subject;
        this.mainProperty = property;
    }

    public static StatementBuilder forSubjectAndProperty(EntityIdValue subject, PropertyIdValue property) {
        return new StatementBuilder(subject, property);
    }

    @Override
    public Statement build() {
        this.prepareBuild();
        return factory.getStatement(this.subject, this.getMainSnak(), this.getQualifierGroups(), this.references, this.rank, this.statementId);
    }

    public StatementBuilder withRank(StatementRank rank) {
        this.rank = rank;
        return this.getThis();
    }

    public StatementBuilder withId(String statementId) {
        this.statementId = statementId;
        return this.getThis();
    }

    public StatementBuilder withValue(Value value) {
        this.mainValue = value;
        return this.getThis();
    }

    public StatementBuilder withSomeValue() {
        this.mainValue = null;
        this.noMainValue = false;
        return this.getThis();
    }

    public StatementBuilder withNoValue() {
        this.mainValue = null;
        this.noMainValue = true;
        return this.getThis();
    }

    public StatementBuilder withQualifierValue(PropertyIdValue propertyIdValue, Value value) {
        this.withQualifier(factory.getValueSnak(propertyIdValue, value));
        return this.getThis();
    }

    public StatementBuilder withQualifierSomeValue(PropertyIdValue propertyIdValue) {
        this.withQualifier(factory.getSomeValueSnak(propertyIdValue));
        return this.getThis();
    }

    public StatementBuilder withQualifierNoValue(PropertyIdValue propertyIdValue) {
        this.withQualifier(factory.getNoValueSnak(propertyIdValue));
        return this.getThis();
    }

    public StatementBuilder withQualifier(Snak qualifier) {
        this.getQualifierList(qualifier.getPropertyId()).add(qualifier);
        return this.getThis();
    }

    public StatementBuilder withQualifiers(SnakGroup qualifiers) {
        this.getQualifierList(qualifiers.getProperty()).addAll(qualifiers);
        return this.getThis();
    }

    public StatementBuilder withQualifiers(List<SnakGroup> qualifiers) {
        for (SnakGroup sg : qualifiers) {
            this.withQualifiers(sg);
        }
        return this.getThis();
    }

    public StatementBuilder withReference(Reference reference) {
        this.references.add(reference);
        return this.getThis();
    }

    public StatementBuilder withReferences(List<? extends Reference> references) {
        this.references.addAll(references);
        return this.getThis();
    }

    @Override
    protected StatementBuilder getThis() {
        return this;
    }

    protected List<SnakGroup> getQualifierGroups() {
        ArrayList<SnakGroup> result = new ArrayList<SnakGroup>(this.qualifiers.size());
        for (ArrayList<Snak> statementList : this.qualifiers.values()) {
            result.add(factory.getSnakGroup(statementList));
        }
        return result;
    }

    protected ArrayList<Snak> getQualifierList(PropertyIdValue propertyIdValue) {
        ArrayList<Snak> result = this.qualifiers.get(propertyIdValue);
        if (result == null) {
            result = new ArrayList();
            this.qualifiers.put(propertyIdValue, result);
        }
        return result;
    }

    protected Snak getMainSnak() {
        if (this.mainValue != null) {
            return factory.getValueSnak(this.mainProperty, this.mainValue);
        }
        if (this.noMainValue) {
            return factory.getNoValueSnak(this.mainProperty);
        }
        return factory.getSomeValueSnak(this.mainProperty);
    }
}

