/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.utils.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentDumpProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.Statement;

public class JsonSerializer
implements EntityDocumentDumpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializer.class);
    private static final byte[] JSON_START_LIST = "[\n".getBytes(Charsets.UTF_8);
    private static final byte[] JSON_SEP = ",\n".getBytes(Charsets.UTF_8);
    private static final byte[] JSON_END_LIST = "\n]".getBytes(Charsets.UTF_8);
    private final OutputStream outputStream;
    protected static final ObjectMapper mapper = new ObjectMapper();
    private int entityDocumentCount;

    public JsonSerializer(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void open() {
        this.entityDocumentCount = 0;
        try {
            this.outputStream.write(JSON_START_LIST);
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        this.serializeEntityDocument(itemDocument);
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        this.serializeEntityDocument(propertyDocument);
    }

    @Override
    public void close() {
        try {
            this.outputStream.write(JSON_END_LIST);
            this.outputStream.close();
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    public int getEntityDocumentCount() {
        return this.entityDocumentCount;
    }

    private void reportException(Exception e) {
        logger.error("Failed to write JSON export: " + e.toString());
        throw new RuntimeException(e.toString(), e);
    }

    private void serializeEntityDocument(EntityDocument entityDocument) {
        try {
            if (this.entityDocumentCount > 0) {
                this.outputStream.write(JSON_SEP);
            }
            mapper.writeValue(this.outputStream, (Object)entityDocument);
        }
        catch (IOException e) {
            this.reportException(e);
        }
        ++this.entityDocumentCount;
    }

    public static String getJsonString(ItemDocument itemDocument) {
        return JsonSerializer.jacksonObjectToString(itemDocument);
    }

    public static String getJsonString(PropertyDocument propertyDocument) {
        return JsonSerializer.jacksonObjectToString(propertyDocument);
    }

    public static String getJsonString(Statement statement) {
        return JsonSerializer.jacksonObjectToString(statement);
    }

    protected static String jacksonObjectToString(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to serialize JSON data: " + e.toString());
            return null;
        }
    }

    static {
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }
}

