/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.implementation.DataObjectFactoryImpl;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class Datamodel {
    public static String SITE_WIKIDATA = "http://www.wikidata.org/entity/";
    private static final DataObjectFactory factory = new DataObjectFactoryImpl();

    public static ItemIdValue makeItemIdValue(String id, String siteIri) {
        return factory.getItemIdValue(id, siteIri);
    }

    public static ItemIdValue makeWikidataItemIdValue(String id) {
        return factory.getItemIdValue(id, SITE_WIKIDATA);
    }

    public static PropertyIdValue makePropertyIdValue(String id, String siteIri) {
        return factory.getPropertyIdValue(id, siteIri);
    }

    public static PropertyIdValue makeWikidataPropertyIdValue(String id) {
        return factory.getPropertyIdValue(id, SITE_WIKIDATA);
    }

    public static LexemeIdValue makeLexemeIdValue(String id, String siteIri) {
        return factory.getLexemeIdValue(id, siteIri);
    }

    public static LexemeIdValue makeWikidataLexemeIdValue(String id) {
        return factory.getLexemeIdValue(id, SITE_WIKIDATA);
    }

    public static FormIdValue makeFormIdValue(String id, String siteIri) {
        return factory.getFormIdValue(id, siteIri);
    }

    public static FormIdValue makeWikidataFormIdValue(String id) {
        return factory.getFormIdValue(id, SITE_WIKIDATA);
    }

    public static SenseIdValue makeSenseIdValue(String id, String siteIri) {
        return factory.getSenseIdValue(id, siteIri);
    }

    public static SenseIdValue makeWikidataSenseIdValue(String id) {
        return factory.getSenseIdValue(id, SITE_WIKIDATA);
    }

    public static DatatypeIdValue makeDatatypeIdValue(String id) {
        return factory.getDatatypeIdValue(id);
    }

    public static TimeValue makeTimeValue(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        return factory.getTimeValue(year, month, day, hour, minute, second, precision, beforeTolerance, afterTolerance, timezoneOffset, calendarModel);
    }

    public static TimeValue makeTimeValue(long year, byte month, byte day, byte hour, byte minute, byte second, int timezoneOffset, String calendarModel) {
        return factory.getTimeValue(year, month, day, hour, minute, second, (byte)14, 0, 0, timezoneOffset, calendarModel);
    }

    public static TimeValue makeTimeValue(long year, byte month, byte day, String calendarModel) {
        return factory.getTimeValue(year, month, day, (byte)0, (byte)0, (byte)0, (byte)11, 0, 0, 0, calendarModel);
    }

    public static GlobeCoordinatesValue makeGlobeCoordinatesValue(double latitude, double longitude, double precision, String globeIri) {
        return factory.getGlobeCoordinatesValue(latitude, longitude, precision, globeIri);
    }

    public static StringValue makeStringValue(String string) {
        return factory.getStringValue(string);
    }

    public static MonolingualTextValue makeMonolingualTextValue(String text, String languageCode) {
        return factory.getMonolingualTextValue(text, languageCode);
    }

    public static QuantityValue makeQuantityValue(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound, String unit) {
        return factory.getQuantityValue(numericValue, lowerBound, upperBound, unit);
    }

    public static QuantityValue makeQuantityValue(BigDecimal numericValue, String unit) {
        return factory.getQuantityValue(numericValue, unit);
    }

    public static QuantityValue makeQuantityValue(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound) {
        return factory.getQuantityValue(numericValue, lowerBound, upperBound);
    }

    public static QuantityValue makeQuantityValue(BigDecimal numericValue) {
        return factory.getQuantityValue(numericValue);
    }

    public static QuantityValue makeQuantityValue(long numericValue, long lowerBound, long upperBound) {
        return factory.getQuantityValue(new BigDecimal(numericValue), new BigDecimal(lowerBound), new BigDecimal(upperBound));
    }

    public static ValueSnak makeValueSnak(PropertyIdValue propertyId, Value value) {
        return factory.getValueSnak(propertyId, value);
    }

    public static SomeValueSnak makeSomeValueSnak(PropertyIdValue propertyId) {
        return factory.getSomeValueSnak(propertyId);
    }

    public static NoValueSnak makeNoValueSnak(PropertyIdValue propertyId) {
        return factory.getNoValueSnak(propertyId);
    }

    public static SnakGroup makeSnakGroup(List<? extends Snak> snaks) {
        return factory.getSnakGroup(snaks);
    }

    public static Claim makeClaim(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        return factory.getClaim(subject, mainSnak, qualifiers);
    }

    public static Reference makeReference(List<SnakGroup> snakGroups) {
        return factory.getReference(snakGroups);
    }

    public static Statement makeStatement(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers, List<Reference> references, StatementRank rank, String statementId) {
        return factory.getStatement(subject, mainSnak, qualifiers, references, rank, statementId);
    }

    public static Statement makeStatement(Claim claim, List<Reference> references, StatementRank rank, String statementId) {
        return factory.getStatement(claim, references, rank, statementId);
    }

    public static StatementGroup makeStatementGroup(List<Statement> statements) {
        return factory.getStatementGroup(statements);
    }

    public static SiteLink makeSiteLink(String title, String siteKey, List<ItemIdValue> badges) {
        return factory.getSiteLink(title, siteKey, badges);
    }

    public static SiteLink makeSiteLink(String title, String siteKey) {
        return factory.getSiteLink(title, siteKey, Collections.emptyList());
    }

    @Deprecated
    public static PropertyDocument makePropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, DatatypeIdValue datatypeId) {
        return Datamodel.makePropertyDocument(propertyId, labels, descriptions, aliases, Collections.emptyList(), datatypeId);
    }

    public static PropertyDocument makePropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, DatatypeIdValue datatypeId) {
        return Datamodel.makePropertyDocument(propertyId, labels, descriptions, aliases, statementGroups, datatypeId, 0L);
    }

    public static PropertyDocument makePropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, DatatypeIdValue datatypeId, long revisionId) {
        return factory.getPropertyDocument(propertyId, labels, descriptions, aliases, statementGroups, datatypeId, revisionId);
    }

    public static ItemDocument makeItemDocument(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks) {
        return Datamodel.makeItemDocument(itemIdValue, labels, descriptions, aliases, statementGroups, siteLinks, 0L);
    }

    public static ItemDocument makeItemDocument(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks, long revisionId) {
        return factory.getItemDocument(itemIdValue, labels, descriptions, aliases, statementGroups, siteLinks, revisionId);
    }

    public static LexemeDocument makeLexemeDocument(LexemeIdValue lexemeIdValue, ItemIdValue lexicalCategory, ItemIdValue language, List<MonolingualTextValue> lemmas, List<StatementGroup> statementGroups, List<FormDocument> forms, List<SenseDocument> senses) {
        return factory.getLexemeDocument(lexemeIdValue, lexicalCategory, language, lemmas, statementGroups, forms, senses, 0L);
    }

    public static FormDocument makeFormDocument(FormIdValue formIdValue, List<MonolingualTextValue> representations, List<ItemIdValue> grammaticalFeatures, List<StatementGroup> statementGroups) {
        return factory.getFormDocument(formIdValue, representations, grammaticalFeatures, statementGroups, 0L);
    }

    public static SenseDocument makeSenseDocument(SenseIdValue senseIdValue, List<MonolingualTextValue> glosses, List<StatementGroup> statementGroups) {
        return factory.getSenseDocument(senseIdValue, glosses, statementGroups, 0L);
    }
}

