/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api.layer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.wicketstuff.openlayers.api.layer.Layer;
import org.wicketstuff.openlayers.js.JSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSM
extends Layer
implements Serializable {
    private OSMLayer layer;

    public OSM(String name, OSMLayer layer) {
        this.setName(name);
        this.layer = layer;
    }

    @Override
    public List<HeaderContributor> getHeaderContributors() {
        ArrayList<HeaderContributor> contributors = new ArrayList<HeaderContributor>();
        contributors.add(new HeaderContributor(new IHeaderContributor(){

            public void renderHead(IHeaderResponse response) {
                response.renderJavascriptReference("http://www.openstreetmap.org/openlayers/OpenStreetMap.js");
            }
        }));
        return contributors;
    }

    @Override
    public String getJSconstructor() {
        String quotedName = JSUtils.getQuotedString(this.getName());
        switch (this.layer) {
            case Mapnik: {
                return this.getJSconstructor("OpenLayers.Layer.OSM.Mapnik", Arrays.asList(quotedName));
            }
            case TilesAtHome: {
                return this.getJSconstructor("OpenLayers.Layer.OSM.Osmarender", Arrays.asList(quotedName));
            }
            case CycleMap: {
                return this.getJSconstructor("OpenLayers.Layer.OSM.CycleMap", Arrays.asList(quotedName));
            }
        }
        return this.getJSconstructor("OpenLayers.Layer.OSM.Mapnik", Arrays.asList(quotedName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSMLayer {
        Mapnik,
        TilesAtHome,
        CycleMap;

    }
}

