/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.wicketstuff.openlayers.OpenLayersMap;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Marker;
import org.wicketstuff.openlayers.api.PopupWindowPanel;

public class InfoWindow
extends WebMarkupContainer {
    private LonLat latLng;
    private Marker marker;
    private PopupWindowPanel content = new PopupWindowPanel();

    public InfoWindow() {
        super("infoWindow");
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.content});
    }

    public void update(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        if (Boolean.parseBoolean(request.getParameter("hidden"))) {
            this.marker = null;
            this.latLng = null;
        }
    }

    public final String getJSinit() {
        if (this.latLng != null) {
            return this.getJSopen(this.latLng);
        }
        if (this.marker != null) {
            return this.getJSopen(this.marker);
        }
        return "";
    }

    public InfoWindow open(LonLat latLng, Component content) {
        return this.open(latLng, content);
    }

    public InfoWindow open(Marker marker, Component content) {
        return this.open(marker, content);
    }

    public InfoWindow open(LonLat latLng) {
        this.latLng = latLng;
        this.marker = null;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavascript(this.getJSopen(latLng));
            AjaxRequestTarget.get().addComponent((Component)this);
        }
        return this;
    }

    public InfoWindow open(Marker marker) {
        this.latLng = null;
        this.marker = marker;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavascript(this.getJSopen(marker));
            AjaxRequestTarget.get().addComponent((Component)this);
        }
        return this;
    }

    public boolean isOpen() {
        return this.latLng != null || this.marker != null;
    }

    public void close() {
        this.marker = null;
        this.latLng = null;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavascript(this.getJSclose());
            AjaxRequestTarget.get().addComponent((Component)this);
        }
    }

    private String getJSopen(LonLat latLng) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("openInfoWindowTabs(");
        buffer.append(latLng.getJSconstructor());
        return this.getGMap2().getJSinvoke(buffer.toString());
    }

    private String getJSopen(Marker marker) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("openMarkerInfoWindowTabs('");
        buffer.append(marker.getId());
        return this.getGMap2().getJSinvoke(buffer.toString());
    }

    private String getJSclose() {
        return this.getGMap2().getJSinvoke("closeInfoWindow()");
    }

    private OpenLayersMap getGMap2() {
        return (OpenLayersMap)this.findParent(OpenLayersMap.class);
    }

    public WebMarkupContainer getContent() {
        return this.content;
    }

    public void setContent(PopupWindowPanel content) {
        this.content = content;
    }
}

