/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers;

import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.wicketstuff.openlayers.OpenLayersMap;

public class OpenLayersMapHeaderContributor
extends HeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference WICKET_OMAP_JS = new JavascriptResourceReference(OpenLayersMap.class, "wicket-openlayersmap.js");

    private static String getURL(boolean developmentMode, String version) {
        String prefix = "http://dev.openlayers.org/releases/OpenLayers-" + version;
        if (developmentMode) {
            return prefix + "/lib/OpenLayers.js";
        }
        return prefix + "/OpenLayers.js";
    }

    public OpenLayersMapHeaderContributor(final boolean developmentMode, final String openLayersVersion) {
        super(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                String url = OpenLayersMapHeaderContributor.getURL(developmentMode, openLayersVersion);
                response.renderJavascriptReference(url);
                response.renderJavascriptReference(WicketEventReference.INSTANCE);
                response.renderJavascriptReference(WicketAjaxReference.INSTANCE);
                response.renderJavascriptReference(WICKET_OMAP_JS);
            }
        });
    }
}

