/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import java.net.URI;
import java.util.Date;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.matchers.http.HasContentLengthMatcher;
import org.valid4j.matchers.http.HasContentTypeMatcher;
import org.valid4j.matchers.http.HasCookieMatcher;
import org.valid4j.matchers.http.HasEntityMatcher;
import org.valid4j.matchers.http.HasEntityWithValueMatcher;
import org.valid4j.matchers.http.HasHeaderMatcher;
import org.valid4j.matchers.http.HasHeaderWithValueMatcher;
import org.valid4j.matchers.http.HasHeaderWithValuesMatcher;
import org.valid4j.matchers.http.HasLastModifiedDate;
import org.valid4j.matchers.http.HasLocation;
import org.valid4j.matchers.http.HasStatusCodeMatcher;
import org.valid4j.matchers.http.HasStatusMatcher;
import org.valid4j.matchers.http.MediaTypeCompatibleWithMatcher;
import org.valid4j.matchers.http.OfFamilyMatcher;
import org.valid4j.matchers.http.OfLanguageMatcher;

public class HttpResponseMatchers {
    private HttpResponseMatchers() {
        throw new AssertionError((Object)"Prevent instantiation");
    }

    public static Matcher<Response> isResponseOk() {
        return CoreMatchers.describedAs((String)"is response ok", HttpResponseMatchers.hasStatusCode(200), (Object[])new Object[0]);
    }

    public static Matcher<Response> hasStatusCode(int n) {
        return HttpResponseMatchers.hasStatusCode((Matcher<Integer>)CoreMatchers.equalTo((Object)n));
    }

    public static Matcher<Response> hasStatusCode(Response.Status.Family family) {
        return HttpResponseMatchers.hasStatusCode(HttpResponseMatchers.ofFamily(family));
    }

    public static Matcher<Response> hasStatusCodeOf(Response.StatusType statusType) {
        return HttpResponseMatchers.hasStatusCode(statusType.getStatusCode());
    }

    public static Matcher<Response> hasStatusCode(Matcher<Integer> matcher) {
        return new HasStatusCodeMatcher(matcher);
    }

    public static Matcher<Response> hasStatus(Response.StatusType statusType) {
        return new HasStatusMatcher(statusType);
    }

    public static Matcher<Response> hasStatus(int n, String string) {
        return new HasStatusMatcher(n, string);
    }

    public static Matcher<Integer> ofFamily(Response.Status.Family family) {
        return new OfFamilyMatcher(family);
    }

    public static Matcher<Response> hasContentType(String string) {
        return HttpResponseMatchers.hasContentType(MediaType.valueOf((String)string));
    }

    public static Matcher<Response> hasContentType(MediaType mediaType) {
        return HttpResponseMatchers.hasContentType((Matcher<? super MediaType>)CoreMatchers.equalTo((Object)mediaType));
    }

    public static Matcher<Response> hasContentType(Matcher<? super MediaType> matcher) {
        return new HasContentTypeMatcher(matcher);
    }

    public static Matcher<MediaType> compatibleWith(MediaType mediaType) {
        return new MediaTypeCompatibleWithMatcher(mediaType);
    }

    public static Matcher<Response> hasHeader(String string) {
        return new HasHeaderMatcher(string);
    }

    public static Matcher<Response> hasHeader(String string, Matcher<?> matcher) {
        return new HasHeaderWithValueMatcher(string, matcher);
    }

    public static Matcher<Response> hasHeaderValues(String string, Matcher<? extends Iterable<?>> matcher) {
        return new HasHeaderWithValuesMatcher(string, matcher);
    }

    public static Matcher<Response> hasCookie(String string) {
        return new HasCookieMatcher(string);
    }

    public static Matcher<Response> hasEntity() {
        return new HasEntityMatcher();
    }

    public static <T> Matcher<Response> hasEntity(Matcher<String> matcher) {
        return new HasEntityWithValueMatcher<String>(String.class, matcher);
    }

    public static <T> Matcher<Response> hasEntity(Class<T> clazz, Matcher<? super T> matcher) {
        return new HasEntityWithValueMatcher<T>(clazz, matcher);
    }

    public static Matcher<Response> ofLanguage(String string) {
        return HttpResponseMatchers.ofLanguage((Matcher<Locale>)CoreMatchers.equalTo((Object)Locale.forLanguageTag(string)));
    }

    public static Matcher<Response> ofLanguage(Locale locale) {
        return HttpResponseMatchers.ofLanguage((Matcher<Locale>)CoreMatchers.equalTo((Object)locale));
    }

    public static Matcher<Response> ofLanguage(Matcher<Locale> matcher) {
        return new OfLanguageMatcher(matcher);
    }

    public static Matcher<Response> hasLastModifiedDate(Matcher<Date> matcher) {
        return new HasLastModifiedDate(matcher);
    }

    public static Matcher<Response> hasContentLength(Matcher<Integer> matcher) {
        return new HasContentLengthMatcher(matcher);
    }

    public static Matcher<Response> hasLocation(URI uRI) {
        return HttpResponseMatchers.hasLocation((Matcher<URI>)CoreMatchers.equalTo((Object)uRI));
    }

    public static Matcher<Response> hasLocation(Matcher<URI> matcher) {
        return new HasLocation(matcher);
    }
}

