/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HasEntityWithValueMatcher<T>
extends TypeSafeMatcher<Response> {
    private final Class<T> entityClass;
    private final Matcher<? super T> entityMatcher;

    public HasEntityWithValueMatcher(Class<T> clazz, Matcher<? super T> matcher) {
        this.entityClass = clazz;
        this.entityMatcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("has entity ").appendDescriptionOf(this.entityMatcher);
    }

    protected boolean matchesSafely(Response response) {
        response.bufferEntity();
        Object object = response.readEntity(this.entityClass);
        return this.entityMatcher.matches(object);
    }

    protected void describeMismatchSafely(Response response, Description description) {
        response.bufferEntity();
        Object object = response.readEntity(this.entityClass);
        description.appendText("entity was ").appendValue(object);
    }
}

