/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.editor.commons.client.file.popups.RestorePopUpPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class RestorePopUpView
implements RestorePopUpPresenter.View,
IsElement {
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="commentTextBox")
    TextBox commentTextBox;
    @Inject
    private TranslationService translationService;
    private RestorePopUpPresenter presenter;
    private BaseModal modal;

    public void init(RestorePopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    @Override
    public void show() {
        this.commentTextBox.setValue((Object)"");
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public String getComment() {
        return this.commentTextBox.getValue();
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.translate("RestorePopUpView.RestoreWithComments")).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
        this.commentTextBox.setPlaceholder(this.translate("ToggleCommentView.EnterComment"));
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(this.translate("RestorePopUpView.Cancel"), this.cancelCommand(), ButtonType.DEFAULT);
        footer.addButton(this.translate("RestorePopUpView.Restore"), this.restoreCommand(), ButtonType.PRIMARY);
        return footer;
    }

    private String translate(String key) {
        return this.translationService.format(key, new Object[0]);
    }

    private Command restoreCommand() {
        return () -> this.presenter.restore();
    }

    private Command cancelCommand() {
        return () -> this.presenter.cancel();
    }
}

