/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import org.uberfire.ext.editor.commons.client.file.exports.FileExport;
import org.uberfire.ext.editor.commons.client.file.exports.PdfDocument;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsPdf;
import org.uberfire.ext.editor.commons.client.file.exports.jso.JsPdfSettings;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;

public class PdfFileExport
implements FileExport<PdfDocument> {
    @Override
    public void export(PdfDocument content, String fileName) {
        this.export(content, fileName, PdfFileExport.createNewDocument(content));
    }

    void export(PdfDocument content, String fileName, JsPdf jsFileExport) {
        content.getPdfEntries().forEach(entry -> this.processEntry(jsFileExport, (PdfDocument.PdfEntry)entry));
        jsFileExport.save(fileName);
    }

    private void processEntry(JsPdf jsFileExport, PdfDocument.PdfEntry entry) {
        if (entry instanceof PdfDocument.Text) {
            PdfDocument.Text text = (PdfDocument.Text)entry;
            jsFileExport.text(text.getText(), text.getX(), text.getY());
        } else if (entry instanceof PdfDocument.Image) {
            PdfDocument.Image image = (PdfDocument.Image)entry;
            jsFileExport.addImage(image.getToDataURL(), image.getImgType(), image.getX(), image.getY(), image.getWidth(), image.getHeight());
        }
    }

    private static JsPdf createNewDocument(PdfDocument content) {
        PdfExportPreferences settings = content.getSettings();
        String orientation = settings.getOrientation().name().toLowerCase();
        String unit = settings.getUnit().name().toLowerCase();
        String format = settings.getFormat().name().toLowerCase();
        JsPdfSettings jsPdfSettings = JsPdfSettings.create(orientation, unit, format);
        return JsPdf.create(jsPdfSettings);
    }
}

