/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.tweets;

import java.io.File;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.UploadedMedia;

public final class UploadMultipleImages {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java twitter4j.examples.tweets.UploadMultipleImages [text] [file1] [file2] ...");
            System.exit(-1);
        }
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            long[] mediaIds = new long[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                System.out.println("Uploading...[" + i + "/" + (args.length - 1) + "][" + args[i] + "]");
                UploadedMedia media = twitter.uploadMedia(new File(args[i]));
                System.out.println("Uploaded: id=" + media.getMediaId() + ", w=" + media.getImageWidth() + ", h=" + media.getImageHeight() + ", type=" + media.getImageType() + ", size=" + media.getSize());
                mediaIds[i - 1] = media.getMediaId();
            }
            StatusUpdate update = new StatusUpdate(args[0]);
            update.setMediaIds(mediaIds);
            Status status = twitter.updateStatus(update);
            System.out.println("Successfully updated the status to [" + status.getText() + "][" + status.getId() + "].");
            System.exit(0);
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to update status: " + te.getMessage());
            System.exit(-1);
        }
    }
}

