/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusEvent;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RateLimitStatusListener;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.auth.BasicAuthorization;
import twitter4j.auth.NullAuthorization;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.auth.OAuthSupport;
import twitter4j.auth.RequestToken;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseEvent;
import twitter4j.internal.http.HttpResponseListener;
import twitter4j.internal.http.XAuthAuthorization;

abstract class TwitterBaseImpl
implements Serializable,
OAuthSupport,
HttpResponseListener {
    protected Configuration conf;
    protected transient String screenName = null;
    protected transient long id = 0L;
    protected transient HttpClientWrapper http;
    private List<RateLimitStatusListener> rateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);
    protected Authorization auth;
    private static final long serialVersionUID = -3812176145960812140L;

    TwitterBaseImpl(Configuration conf) {
        this.conf = conf;
        this.init();
    }

    TwitterBaseImpl(Configuration conf, Authorization auth) {
        this.conf = conf;
        this.auth = auth;
        this.init();
    }

    private void init() {
        if (null == this.auth) {
            String consumerKey = this.conf.getOAuthConsumerKey();
            String consumerSecret = this.conf.getOAuthConsumerSecret();
            if (null != consumerKey && null != consumerSecret) {
                OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
                String accessToken = this.conf.getOAuthAccessToken();
                String accessTokenSecret = this.conf.getOAuthAccessTokenSecret();
                if (null != accessToken && null != accessTokenSecret) {
                    oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
                }
                this.auth = oauth;
            } else {
                this.auth = NullAuthorization.getInstance();
            }
        }
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
    }

    public String getScreenName() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (null == this.screenName) {
            if (this.auth instanceof BasicAuthorization) {
                this.screenName = ((BasicAuthorization)this.auth).getUserId();
                if (-1 != this.screenName.indexOf("@")) {
                    this.screenName = null;
                }
            }
            if (null == this.screenName) {
                this.fillInIDAndScreenName();
            }
        }
        return this.screenName;
    }

    public long getId() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (0L == this.id) {
            this.fillInIDAndScreenName();
        }
        return this.id;
    }

    protected User fillInIDAndScreenName() throws TwitterException {
        this.ensureAuthorizationEnabled();
        UserJSONImpl user = new UserJSONImpl(this.http.get(this.conf.getRestBaseURL() + "account/verify_credentials.json?include_entities=" + this.conf.isIncludeEntitiesEnabled(), this.auth));
        this.screenName = user.getScreenName();
        this.id = user.getId();
        return user;
    }

    public void addRateLimitStatusListener(RateLimitStatusListener listener) {
        this.rateLimitStatusListeners.add(listener);
    }

    public void httpResponseReceived(HttpResponseEvent event) {
        block7: {
            int statusCode;
            RateLimitStatus rateLimitStatus;
            if (this.rateLimitStatusListeners.size() == 0) break block7;
            HttpResponse res = event.getResponse();
            TwitterException te = event.getTwitterException();
            if (null != te) {
                rateLimitStatus = te.getRateLimitStatus();
                statusCode = te.getStatusCode();
            } else {
                rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
                statusCode = res.getStatusCode();
            }
            if (null != rateLimitStatus) {
                RateLimitStatusEvent statusEvent = new RateLimitStatusEvent(this, rateLimitStatus, event.isAuthenticated());
                if (statusCode == 420 || statusCode == 503) {
                    Iterator<RateLimitStatusListener> i$ = this.rateLimitStatusListeners.iterator();
                    while (i$.hasNext()) {
                        RateLimitStatusListener listener = i$.next();
                        listener.onRateLimitStatus(statusEvent);
                        listener.onRateLimitReached(statusEvent);
                    }
                } else {
                    Iterator<RateLimitStatusListener> i$ = this.rateLimitStatusListeners.iterator();
                    while (i$.hasNext()) {
                        RateLimitStatusListener listener = i$.next();
                        listener.onRateLimitStatus(statusEvent);
                    }
                }
            }
        }
    }

    public final Authorization getAuthorization() {
        return this.auth;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void shutdown() {
        if (this.http != null) {
            this.http.shutdown();
        }
    }

    protected final void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing. See http://twitter4j.org/configuration.html for the detail.");
        }
    }

    protected final void ensureOAuthEnabled() {
        if (!(this.auth instanceof OAuthAuthorization)) {
            throw new IllegalStateException("OAuth required. Authentication credentials are missing. See http://twitter4j.org/configuration.html for the detail.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.conf);
        out.writeObject(this.auth);
        ArrayList<RateLimitStatusListener> serializableRateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);
        Iterator<RateLimitStatusListener> i$ = this.rateLimitStatusListeners.iterator();
        while (i$.hasNext()) {
            RateLimitStatusListener listener = i$.next();
            if (!(listener instanceof Serializable)) continue;
            serializableRateLimitStatusListeners.add(listener);
        }
        out.writeObject(serializableRateLimitStatusListeners);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.conf = (Configuration)stream.readObject();
        this.auth = (Authorization)stream.readObject();
        this.rateLimitStatusListeners = (List)stream.readObject();
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
    }

    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        if (null == consumerKey) {
            throw new NullPointerException("consumer key is null");
        }
        if (null == consumerSecret) {
            throw new NullPointerException("consumer secret is null");
        }
        if (this.auth instanceof NullAuthorization) {
            OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
            oauth.setOAuthConsumer(consumerKey, consumerSecret);
            this.auth = oauth;
        } else if (this.auth instanceof BasicAuthorization) {
            XAuthAuthorization xauth = new XAuthAuthorization((BasicAuthorization)this.auth);
            xauth.setOAuthConsumer(consumerKey, consumerSecret);
            this.auth = xauth;
        } else if (this.auth instanceof OAuthAuthorization) {
            throw new IllegalStateException("consumer key/secret pair already set.");
        }
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null);
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.getOAuth().getOAuthRequestToken(callbackUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized AccessToken getOAuthAccessToken() throws TwitterException {
        AccessToken oauthAccessToken;
        Authorization auth = this.getAuthorization();
        if (auth instanceof BasicAuthorization) {
            BasicAuthorization basicAuth = (BasicAuthorization)auth;
            auth = AuthorizationFactory.getInstance(this.conf);
            if (!(auth instanceof OAuthAuthorization)) throw new IllegalStateException("consumer key / secret combination not supplied.");
            this.auth = auth;
            OAuthAuthorization oauthAuth = (OAuthAuthorization)auth;
            oauthAccessToken = oauthAuth.getOAuthAccessToken(basicAuth.getUserId(), basicAuth.getPassword());
        } else if (auth instanceof XAuthAuthorization) {
            XAuthAuthorization xauth = (XAuthAuthorization)auth;
            this.auth = xauth;
            OAuthAuthorization oauthAuth = new OAuthAuthorization(this.conf);
            oauthAuth.setOAuthConsumer(xauth.getConsumerKey(), xauth.getConsumerSecret());
            oauthAccessToken = oauthAuth.getOAuthAccessToken(xauth.getUserId(), xauth.getPassword());
        } else {
            oauthAccessToken = this.getOAuth().getOAuthAccessToken();
        }
        this.screenName = oauthAccessToken.getScreenName();
        this.id = oauthAccessToken.getUserId();
        return oauthAccessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        AccessToken oauthAccessToken = this.getOAuth().getOAuthAccessToken(oauthVerifier);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        OAuthSupport oauth = this.getOAuth();
        AccessToken oauthAccessToken = oauth.getOAuthAccessToken(requestToken);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public synchronized void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    public synchronized AccessToken getOAuthAccessToken(String screenName, String password) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(screenName, password);
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth consumer key/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterBaseImpl)) {
            return false;
        }
        TwitterBaseImpl that = (TwitterBaseImpl)o;
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (!this.conf.equals(that.conf)) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        return ((Object)this.rateLimitStatusListeners).equals(that.rateLimitStatusListeners);
    }

    public int hashCode() {
        int result = this.conf.hashCode();
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + ((Object)this.rateLimitStatusListeners).hashCode();
        result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TwitterBase{conf=" + this.conf + ", http=" + this.http + ", rateLimitStatusListeners=" + this.rateLimitStatusListeners + ", auth=" + this.auth + '}';
    }
}

