/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.AbstractStreamImplementation;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

class StatusStreamImpl
extends AbstractStreamImplementation
implements StatusStream {
    private String line;
    private StreamListener[] listeners;

    StatusStreamImpl(InputStream stream) throws IOException {
        super(stream);
    }

    StatusStreamImpl(HttpResponse response) throws IOException {
        super(response);
    }

    public void next(StatusListener listener) throws TwitterException {
        StreamListener[] list = new StreamListener[]{listener};
        this.listeners = list;
        this.handleNextElement();
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        this.listeners = listeners;
        this.handleNextElement();
    }

    protected String parseLine(String line) {
        DataObjectFactoryUtil.clearThreadLocalMap();
        this.line = line;
        return line;
    }

    protected void onText(JSONObject json) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((StatusListener)listener).onStatus(this.asStatus(json));
        }
    }

    protected void onDelete(JSONObject json) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((StatusListener)listener).onDeletionNotice(new StatusDeletionNoticeImpl(json));
        }
    }

    protected void onLimit(JSONObject json) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((StatusListener)listener).onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
        }
    }

    public void onException(Exception e) {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            listener.onException(e);
        }
    }
}

