/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.web;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.spring.web.FeaturesAreActive;

public class FeatureInterceptor
extends HandlerInterceptorAdapter {
    private ConcurrentHashMap<HandlerMethod, AnnotationHolder<FeaturesAreActive>> annotations = new ConcurrentHashMap();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            AnnotationHolder<FeaturesAreActive> annotationHolder = this.annotations.get(handlerMethod);
            if (annotationHolder == null) {
                FeaturesAreActive foundAnnotation = FeatureInterceptor.handlerAnnotation(handlerMethod, FeaturesAreActive.class);
                this.annotations.putIfAbsent(handlerMethod, new AnnotationHolder<FeaturesAreActive>(foundAnnotation));
                annotationHolder = this.annotations.get(handlerMethod);
            }
            if (annotationHolder.hasAnnotation()) {
                FeaturesAreActive featuresAreActiveAnnotation = annotationHolder.getAnnotation();
                if (!Enum.class.isAssignableFrom(featuresAreActiveAnnotation.featureClass())) {
                    throw new IllegalArgumentException("The featureClass of the " + FeaturesAreActive.class.getSimpleName() + " annotation must be an enum");
                }
                for (String f : featuresAreActiveAnnotation.features()) {
                    Feature feature = FeatureInterceptor.enumFrom(f, featuresAreActiveAnnotation.featureClass());
                    if (feature == null || FeatureContext.getFeatureManager().isActive(feature)) continue;
                    response.sendError(featuresAreActiveAnnotation.responseStatus());
                    return false;
                }
            }
        }
        return super.preHandle(request, response, handler);
    }

    protected static <A extends Annotation> A handlerAnnotation(HandlerMethod handlerMethod, Class<A> annotationClass) {
        Annotation annotation = handlerMethod.getMethodAnnotation(annotationClass);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), annotationClass);
        }
        return (A)annotation;
    }

    protected static <T extends Enum<?>> T enumFrom(String name, Class<T> enumType) {
        if (name != null) {
            for (Enum item : (Enum[])enumType.getEnumConstants()) {
                if (!name.equals(item.name())) continue;
                return (T)item;
            }
        }
        return null;
    }

    private static final class AnnotationHolder<A extends Annotation> {
        private final A annotation;

        public AnnotationHolder(A annotation) {
            this.annotation = annotation;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public boolean hasAnnotation() {
            return this.annotation != null;
        }
    }
}

