/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.activation;

import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.togglz.core.activation.AbstractPropertyDrivenActivationStrategy;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.FeatureUser;
import org.togglz.spring.util.ContextClassLoaderApplicationContextHolder;

public class SpringEnvironmentPropertyActivationStrategy
extends AbstractPropertyDrivenActivationStrategy {
    public static final String ID = "spring-environment-property";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Spring Environment Property";
    }

    protected String getPropertyValue(FeatureState featureState, FeatureUser user, String name) {
        ApplicationContext applicationContext = ContextClassLoaderApplicationContextHolder.get();
        if (applicationContext == null) {
            throw new IllegalStateException("ApplicationContext could not be found, which can occur if there is no bean for TogglzApplicationContextBinderApplicationListener when TogglzAutoConfiguration is not being used");
        }
        Environment environment = applicationContext.getEnvironment();
        return environment.getProperty(name);
    }
}

