/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.listener;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.listener.FeatureStateChangedListener;
import org.togglz.core.util.Weighted;

public class ListenableStateRepository
implements StateRepository {
    private static final Weighted.WeightedComparator WEIGHTED_COMPARATOR = new Weighted.WeightedComparator();
    private final List<FeatureStateChangedListener> listeners;
    private final StateRepository delegate;

    public ListenableStateRepository(StateRepository delegate, Collection<FeatureStateChangedListener> listeners) {
        this.delegate = delegate;
        this.listeners = new CopyOnWriteArrayList<FeatureStateChangedListener>(listeners);
        this.listeners.sort(WEIGHTED_COMPARATOR);
    }

    public ListenableStateRepository(StateRepository delegate, FeatureStateChangedListener ... listeners) {
        this.delegate = delegate;
        this.listeners = new CopyOnWriteArrayList<FeatureStateChangedListener>(listeners);
        this.listeners.sort(WEIGHTED_COMPARATOR);
    }

    public final void addFeatureStateChangedListener(FeatureStateChangedListener listener) {
        this.listeners.add(listener);
        this.listeners.sort(WEIGHTED_COMPARATOR);
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        return this.delegate.getFeatureState(feature);
    }

    @Override
    public void setFeatureState(FeatureState featureState) {
        FeatureState fromState = this.getFeatureState(featureState.getFeature());
        this.delegate.setFeatureState(featureState);
        this.listeners.forEach(listener -> listener.onFeatureStateChanged(fromState, featureState));
    }
}

