/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.metadata.enums;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.metadata.FeatureGroup;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.enums.AnnotationFeatureGroup;
import org.togglz.core.util.FeatureAnnotations;

public class EnumFeatureMetaData
implements FeatureMetaData {
    private final String label;
    private final boolean enabledByDefault;
    private final Set<FeatureGroup> groups = new HashSet<FeatureGroup>();
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    public EnumFeatureMetaData(Feature feature) {
        this.label = FeatureAnnotations.getLabel(feature);
        this.enabledByDefault = FeatureAnnotations.isEnabledByDefault(feature);
        for (Annotation annotation : FeatureAnnotations.getAnnotations(feature)) {
            String[] attribute;
            FeatureGroup group = AnnotationFeatureGroup.build(annotation.annotationType());
            if (group != null) {
                this.groups.add(group);
            }
            if ((attribute = FeatureAnnotations.getFeatureAttribute(annotation)) == null) continue;
            this.attributes.put(attribute[0], attribute[1]);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    @Override
    public Set<FeatureGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

