/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.activation;

import java.util.Collection;
import java.util.List;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;

public class UserRoleActivationStrategy
implements ActivationStrategy {
    public static final String ID = "user-role";
    public static final String NAME = "Users by role";
    public static final String PARAM_ROLES_NAME = "roles";
    public static final String PARAM_ROLES_LABEL = "Roles";
    public static final String PARAM_ROLES_DESC = "A list of user roles for which the feature is active.";
    public static final String USER_ATTRIBUTE_ROLES = "roles";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isActive(FeatureState state, FeatureUser user) {
        String rolesAsString;
        Collection userRoles;
        if (user != null && (userRoles = (Collection)user.getAttribute("roles")) != null && Strings.isNotBlank(rolesAsString = state.getParameter("roles"))) {
            List<String> roles = Strings.splitAndTrim(rolesAsString, ",");
            for (String authority : roles) {
                if (!userRoles.contains(authority)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create("roles").label(PARAM_ROLES_LABEL).description(PARAM_ROLES_DESC).largeText()};
    }
}

