/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.activation;

import java.util.Locale;
import org.togglz.core.Feature;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;
import org.togglz.core.util.Validate;

public class GradualActivationStrategy
implements ActivationStrategy {
    private final Log log = LogFactory.getLog(GradualActivationStrategy.class);
    public static final String ID = "gradual";
    public static final String PARAM_PERCENTAGE = "percentage";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Gradual rollout";
    }

    @Override
    public boolean isActive(FeatureState state, FeatureUser user) {
        if (user != null && Strings.isNotBlank(user.getName())) {
            String percentageAsString = state.getParameter(PARAM_PERCENTAGE);
            try {
                int percentage = Integer.valueOf(percentageAsString);
                if (percentage > 0) {
                    int hashCode = Math.abs(this.calculateHashCode(user, state.getFeature()));
                    return hashCode % 100 < percentage;
                }
            }
            catch (NumberFormatException e) {
                this.log.error("Invalid gradual rollout percentage for feature " + state.getFeature().name() + ": " + percentageAsString);
            }
        }
        return false;
    }

    @Deprecated
    protected int calculateHashCode(FeatureUser user) {
        return this.calculateHashCode(user, null);
    }

    protected int calculateHashCode(FeatureUser user, Feature feature) {
        Validate.notNull(user, "user is required");
        return (user.getName().toLowerCase(Locale.ENGLISH).trim() + ":" + (feature != null ? feature.name() : "")).hashCode();
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create(PARAM_PERCENTAGE).label("Percentage").matching("\\d{1,3}").description("Percentage of users for which the feature should be active (i.e. '25' for every fourth user).")};
    }
}

