/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

public final class WeekFields
implements Serializable {
    private static final ConcurrentMap<String, WeekFields> CACHE = new ConcurrentHashMap<String, WeekFields>(4, 0.75f, 2);
    public static final WeekFields ISO = new WeekFields(DayOfWeek.MONDAY, 4);
    public static final WeekFields SUNDAY_START = WeekFields.of(DayOfWeek.SUNDAY, 1);
    private static final long serialVersionUID = -1177360819670808121L;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;
    private final transient TemporalField dayOfWeek = ComputedDayOfField.ofDayOfWeekField(this);
    private final transient TemporalField weekOfMonth = ComputedDayOfField.ofWeekOfMonthField(this);
    private final transient TemporalField weekOfYear = ComputedDayOfField.ofWeekOfYearField(this);

    public static WeekFields of(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        GregorianCalendar gcal = new GregorianCalendar(locale);
        int calDow = gcal.getFirstDayOfWeek();
        DayOfWeek dow = DayOfWeek.SUNDAY.plus(calDow - 1);
        int minDays = gcal.getMinimalDaysInFirstWeek();
        return WeekFields.of(dow, minDays);
    }

    public static WeekFields of(DayOfWeek firstDayOfWeek, int minimalDaysInFirstWeek) {
        String key = firstDayOfWeek.toString() + minimalDaysInFirstWeek;
        WeekFields rules = (WeekFields)CACHE.get(key);
        if (rules == null) {
            rules = new WeekFields(firstDayOfWeek, minimalDaysInFirstWeek);
            CACHE.putIfAbsent(key, rules);
            rules = (WeekFields)CACHE.get(key);
        }
        return rules;
    }

    private WeekFields(DayOfWeek firstDayOfWeek, int minimalDaysInFirstWeek) {
        Objects.requireNonNull(firstDayOfWeek, "firstDayOfWeek");
        if (minimalDaysInFirstWeek < 1 || minimalDaysInFirstWeek > 7) {
            throw new IllegalArgumentException("Minimal number of days is invalid");
        }
        this.firstDayOfWeek = firstDayOfWeek;
        this.minimalDays = minimalDaysInFirstWeek;
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return WeekFields.of(this.firstDayOfWeek, this.minimalDays);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidObjectException("Invalid WeekFields" + ex.getMessage());
        }
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDays;
    }

    public TemporalField dayOfWeek() {
        return this.dayOfWeek;
    }

    public TemporalField weekOfMonth() {
        return this.weekOfMonth;
    }

    public TemporalField weekOfYear() {
        return this.weekOfYear;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekFields) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.firstDayOfWeek.ordinal() * 7 + this.minimalDays;
    }

    public String toString() {
        return "WeekFields[" + this.firstDayOfWeek + ',' + this.minimalDays + ']';
    }

    static class ComputedDayOfField
    implements TemporalField {
        private final String name;
        private final WeekFields weekDef;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;
        private static final ValueRange DAY_OF_WEEK_RANGE = ValueRange.of(1L, 7L);
        private static final ValueRange WEEK_OF_MONTH_RANGE = ValueRange.of(0L, 1L, 4L, 5L);
        private static final ValueRange WEEK_OF_YEAR_RANGE = ValueRange.of(0L, 1L, 52L, 53L);

        static ComputedDayOfField ofDayOfWeekField(WeekFields weekDef) {
            return new ComputedDayOfField("DayOfWeek", weekDef, ChronoUnit.DAYS, ChronoUnit.WEEKS, DAY_OF_WEEK_RANGE);
        }

        static ComputedDayOfField ofWeekOfMonthField(WeekFields weekDef) {
            return new ComputedDayOfField("WeekOfMonth", weekDef, ChronoUnit.WEEKS, ChronoUnit.MONTHS, WEEK_OF_MONTH_RANGE);
        }

        static ComputedDayOfField ofWeekOfYearField(WeekFields weekDef) {
            return new ComputedDayOfField("WeekOfYear", weekDef, ChronoUnit.WEEKS, ChronoUnit.YEARS, WEEK_OF_YEAR_RANGE);
        }

        private ComputedDayOfField(String name, WeekFields weekDef, TemporalUnit baseUnit, TemporalUnit rangeUnit, ValueRange range) {
            this.name = name;
            this.weekDef = weekDef;
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.range = range;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            int sow = this.weekDef.getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField.DAY_OF_WEEK);
            int dow = Jdk8Methods.floorMod(isoDow - sow, 7) + 1;
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return dow;
            }
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                int dom = temporal.get(ChronoField.DAY_OF_MONTH);
                int offset = this.startOfWeekOffset(dom, dow);
                return this.computeWeek(offset, dom);
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                int doy = temporal.get(ChronoField.DAY_OF_YEAR);
                int offset = this.startOfWeekOffset(doy, dow);
                return this.computeWeek(offset, doy);
            }
            throw new IllegalStateException("unreachable");
        }

        private int localizedDayOfWeek(TemporalAccessor temporal, int sow) {
            int isoDow = temporal.get(ChronoField.DAY_OF_WEEK);
            return Jdk8Methods.floorMod(isoDow - sow, 7) + 1;
        }

        private long localizedWeekOfMonth(TemporalAccessor temporal, int dow) {
            int dom = temporal.get(ChronoField.DAY_OF_MONTH);
            int offset = this.startOfWeekOffset(dom, dow);
            return this.computeWeek(offset, dom);
        }

        private long localizedWeekOfYear(TemporalAccessor temporal, int dow) {
            int doy = temporal.get(ChronoField.DAY_OF_YEAR);
            int offset = this.startOfWeekOffset(doy, dow);
            return this.computeWeek(offset, doy);
        }

        private int startOfWeekOffset(int day, int dow) {
            int weekStart = Jdk8Methods.floorMod(day - dow, 7);
            int offset = -weekStart;
            if (weekStart + 1 > this.weekDef.getMinimalDaysInFirstWeek()) {
                offset = 7 - weekStart;
            }
            return offset;
        }

        private int computeWeek(int offset, int day) {
            return (7 + offset + (day - 1)) / 7;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            int currentVal;
            int newVal = this.range.checkValidIntValue(newValue, this);
            if (newVal == (currentVal = temporal.get(this))) {
                return temporal;
            }
            int delta = newVal - currentVal;
            return (R)temporal.plus(delta, this.baseUnit);
        }

        @Override
        public Map<TemporalField, Long> resolve(TemporalAccessor temporal, long value) {
            int newValue = this.range.checkValidIntValue(value, this);
            int sow = this.weekDef.getFirstDayOfWeek().getValue();
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                int isoDow = Jdk8Methods.floorMod(sow - 1 + (newValue - 1), 7) + 1;
                return Collections.singletonMap(ChronoField.DAY_OF_WEEK, Long.valueOf(isoDow));
            }
            if (!(temporal.isSupported(ChronoField.YEAR) && temporal.isSupported(ChronoField.DAY_OF_WEEK))) {
                return null;
            }
            int dow = this.localizedDayOfWeek(temporal, sow);
            int year = temporal.get(ChronoField.YEAR);
            Chronology chrono = Chronology.from(temporal);
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                if (!temporal.isSupported(ChronoField.MONTH_OF_YEAR)) {
                    return null;
                }
                int month = temporal.get(ChronoField.MONTH_OF_YEAR);
                ChronoLocalDate<?> date = chrono.date(year, month, 1);
                int dateDow = this.localizedDayOfWeek(date, sow);
                long weeks = (long)newValue - this.localizedWeekOfMonth(date, dateDow);
                int days = dow - dateDow;
                date = date.plus(weeks * 7L + (long)days, ChronoUnit.DAYS);
                HashMap<TemporalField, Long> result = new HashMap<TemporalField, Long>(4, 1.0f);
                result.put(ChronoField.EPOCH_DAY, date.toEpochDay());
                result.put(ChronoField.YEAR, null);
                result.put(ChronoField.MONTH_OF_YEAR, null);
                result.put(ChronoField.DAY_OF_WEEK, null);
                return result;
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                ChronoLocalDate<?> date = chrono.date(year, 1, 1);
                int dateDow = this.localizedDayOfWeek(date, sow);
                long weeks = (long)newValue - this.localizedWeekOfYear(date, dateDow);
                int days = dow - dateDow;
                date = date.plus(weeks * 7L + (long)days, ChronoUnit.DAYS);
                HashMap<TemporalField, Long> result = new HashMap<TemporalField, Long>(4, 1.0f);
                result.put(ChronoField.EPOCH_DAY, date.toEpochDay());
                result.put(ChronoField.YEAR, null);
                result.put(ChronoField.DAY_OF_WEEK, null);
                return result;
            }
            throw new IllegalStateException("unreachable");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public int compare(TemporalAccessor temporal1, TemporalAccessor temporal2) {
            return Long.compare(temporal1.getLong(this), temporal2.getLong(this));
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            if (temporal.isSupported(ChronoField.DAY_OF_WEEK)) {
                if (this.rangeUnit == ChronoUnit.WEEKS) {
                    return true;
                }
                if (this.rangeUnit == ChronoUnit.MONTHS) {
                    return temporal.isSupported(ChronoField.DAY_OF_MONTH);
                }
                if (this.rangeUnit == ChronoUnit.YEARS) {
                    return temporal.isSupported(ChronoField.DAY_OF_YEAR);
                }
            }
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return this.range;
            }
            ChronoField field = null;
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                field = ChronoField.DAY_OF_MONTH;
            } else if (this.rangeUnit == ChronoUnit.YEARS) {
                field = ChronoField.DAY_OF_YEAR;
            } else {
                throw new IllegalStateException("unreachable");
            }
            int sow = this.weekDef.getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField.DAY_OF_WEEK);
            int dow = Jdk8Methods.floorMod(isoDow - sow, 7) + 1;
            int offset = this.startOfWeekOffset(temporal.get(field), dow);
            ValueRange fieldRange = temporal.range(field);
            return ValueRange.of(this.computeWeek(offset, (int)fieldRange.getMinimum()), this.computeWeek(offset, (int)fieldRange.getMaximum()));
        }

        public String toString() {
            return this.getName() + "[" + this.weekDef.toString() + "]";
        }
    }
}

