/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.util.HashMap;
import java.util.Map;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.Duration;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

public final class IsoFields {
    public static final TemporalField DAY_OF_QUARTER = Field.DAY_OF_QUARTER;
    public static final TemporalField QUARTER_OF_YEAR = Field.QUARTER_OF_YEAR;
    public static final TemporalField WEEK_OF_WEEK_BASED_YEAR = Field.WEEK_OF_WEEK_BASED_YEAR;
    public static final TemporalField WEEK_BASED_YEAR = Field.WEEK_BASED_YEAR;
    public static final TemporalUnit WEEK_BASED_YEARS = Unit.WEEK_BASED_YEARS;
    public static final TemporalUnit QUARTER_YEARS = Unit.QUARTER_YEARS;

    private IsoFields() {
        throw new AssertionError((Object)"Not instantiable");
    }

    private static enum Unit implements TemporalUnit
    {
        WEEK_BASED_YEARS("WeekBasedYears", Duration.ofSeconds(31556952L)),
        QUARTER_YEARS("QuarterYears", Duration.ofSeconds(7889238L));

        private final String name;
        private final Duration duration;

        private Unit(String name, Duration estimatedDuration) {
            this.name = name;
            this.duration = estimatedDuration;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public boolean isDurationEstimated() {
            return true;
        }

        @Override
        public boolean isSupportedBy(Temporal temporal) {
            return temporal.isSupported(ChronoField.EPOCH_DAY);
        }

        @Override
        public <R extends Temporal> R addTo(R temporal, long periodToAdd) {
            switch (this) {
                case WEEK_BASED_YEARS: {
                    long added = Jdk8Methods.safeAdd((long)temporal.get(WEEK_BASED_YEAR), periodToAdd);
                    return (R)temporal.with(WEEK_BASED_YEAR, added);
                }
                case QUARTER_YEARS: {
                    return (R)temporal.plus(periodToAdd / 256L, ChronoUnit.YEARS).plus(periodToAdd % 256L * 3L, ChronoUnit.MONTHS);
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @Override
        public long between(Temporal temporal1, Temporal temporal2) {
            switch (this) {
                case WEEK_BASED_YEARS: {
                    return Jdk8Methods.safeSubtract(temporal2.getLong(WEEK_BASED_YEAR), temporal1.getLong(WEEK_BASED_YEAR));
                }
                case QUARTER_YEARS: {
                    return temporal1.periodUntil(temporal2, ChronoUnit.MONTHS) / 3L;
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private static enum Field implements TemporalField
    {
        DAY_OF_QUARTER{

            @Override
            public String getName() {
                return "DayOfQuarter";
            }

            @Override
            public TemporalUnit getBaseUnit() {
                return ChronoUnit.DAYS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return QUARTER_YEARS;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(1L, 90L, 92L);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporal) {
                return temporal.isSupported(ChronoField.DAY_OF_YEAR) && temporal.isSupported(ChronoField.MONTH_OF_YEAR) && temporal.isSupported(ChronoField.YEAR) && Field.isIso(temporal);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                if (!temporal.isSupported(this)) {
                    throw new DateTimeException("Unsupported field: DayOfQuarter");
                }
                long qoy = temporal.getLong(QUARTER_OF_YEAR);
                if (qoy == 1L) {
                    long year = temporal.getLong(ChronoField.YEAR);
                    return IsoChronology.INSTANCE.isLeapYear(year) ? ValueRange.of(1L, 91L) : ValueRange.of(1L, 90L);
                }
                if (qoy == 2L) {
                    return ValueRange.of(1L, 91L);
                }
                if (qoy == 3L || qoy == 4L) {
                    return ValueRange.of(1L, 92L);
                }
                return this.range();
            }

            @Override
            public long getFrom(TemporalAccessor temporal) {
                if (!temporal.isSupported(this)) {
                    throw new DateTimeException("Unsupported field: DayOfQuarter");
                }
                int doy = temporal.get(ChronoField.DAY_OF_YEAR);
                int moy = temporal.get(ChronoField.MONTH_OF_YEAR);
                long year = temporal.getLong(ChronoField.YEAR);
                return doy - QUARTER_DAYS[(moy - 1) / 3 + (IsoChronology.INSTANCE.isLeapYear(year) ? 4 : 0)];
            }

            @Override
            public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                long curValue = this.getFrom(temporal);
                this.range().checkValidValue(newValue, this);
                return (R)temporal.with(ChronoField.DAY_OF_YEAR, temporal.getLong(ChronoField.DAY_OF_YEAR) + (newValue - curValue));
            }

            @Override
            public Map<TemporalField, Long> resolve(TemporalAccessor temporal, long value) {
                if (!(temporal.isSupported(ChronoField.YEAR) && temporal.isSupported(DAY_OF_QUARTER))) {
                    return null;
                }
                int y = temporal.get(ChronoField.YEAR);
                int qoy = temporal.get(QUARTER_OF_YEAR);
                this.range().checkValidValue(value, this);
                LocalDate date = LocalDate.of(y, (qoy - 1) * 3 + 1, 1).plusDays(value - 1L);
                HashMap<TemporalField, Long> result = new HashMap<TemporalField, Long>(4, 1.0f);
                result.put(ChronoField.EPOCH_DAY, date.toEpochDay());
                result.put(ChronoField.YEAR, null);
                result.put(QUARTER_OF_YEAR, null);
                return result;
            }
        }
        ,
        QUARTER_OF_YEAR{

            @Override
            public String getName() {
                return "QuarterOfYear";
            }

            @Override
            public TemporalUnit getBaseUnit() {
                return QUARTER_YEARS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return ChronoUnit.YEARS;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(1L, 4L);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporal) {
                return temporal.isSupported(ChronoField.MONTH_OF_YEAR) && Field.isIso(temporal);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                return this.range();
            }

            @Override
            public long getFrom(TemporalAccessor temporal) {
                if (!temporal.isSupported(this)) {
                    throw new DateTimeException("Unsupported field: QuarterOfYear");
                }
                long moy = temporal.getLong(ChronoField.MONTH_OF_YEAR);
                return (moy + 2L) / 3L;
            }

            @Override
            public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                long curValue = this.getFrom(temporal);
                this.range().checkValidValue(newValue, this);
                return (R)temporal.with(ChronoField.MONTH_OF_YEAR, temporal.getLong(ChronoField.MONTH_OF_YEAR) + (newValue - curValue) * 3L);
            }
        }
        ,
        WEEK_OF_WEEK_BASED_YEAR{

            @Override
            public String getName() {
                return "WeekOfWeekBasedYear";
            }

            @Override
            public TemporalUnit getBaseUnit() {
                return ChronoUnit.WEEKS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return WEEK_BASED_YEARS;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(1L, 52L, 53L);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporal) {
                return temporal.isSupported(ChronoField.EPOCH_DAY) && Field.isIso(temporal);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                if (!temporal.isSupported(this)) {
                    throw new DateTimeException("Unsupported field: WeekOfWeekBasedYear");
                }
                return Field.getWeekRange(LocalDate.from(temporal));
            }

            @Override
            public long getFrom(TemporalAccessor temporal) {
                if (!temporal.isSupported(this)) {
                    throw new DateTimeException("Unsupported field: WeekOfWeekBasedYear");
                }
                return Field.getWeek(LocalDate.from(temporal));
            }

            @Override
            public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                this.range().checkValidValue(newValue, this);
                return (R)temporal.plus(Jdk8Methods.safeSubtract(newValue, this.getFrom(temporal)), ChronoUnit.WEEKS);
            }

            @Override
            public Map<TemporalField, Long> resolve(TemporalAccessor temporal, long value) {
                if (!(temporal.isSupported(WEEK_BASED_YEAR) && temporal.isSupported(ChronoField.DAY_OF_WEEK))) {
                    return null;
                }
                int wby = temporal.get(WEEK_BASED_YEAR);
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                this.range().checkValidValue(value, this);
                LocalDate date = LocalDate.of(wby, 1, 4).plusWeeks(value - 1L).with(ChronoField.DAY_OF_WEEK, dow);
                HashMap<TemporalField, Long> result = new HashMap<TemporalField, Long>(2, 1.0f);
                result.put(ChronoField.EPOCH_DAY, date.toEpochDay());
                result.put(WEEK_BASED_YEAR, null);
                result.put(ChronoField.DAY_OF_WEEK, null);
                return result;
            }
        }
        ,
        WEEK_BASED_YEAR{

            @Override
            public String getName() {
                return "WeekBasedYear";
            }

            @Override
            public TemporalUnit getBaseUnit() {
                return WEEK_BASED_YEARS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return ChronoUnit.FOREVER;
            }

            @Override
            public ValueRange range() {
                return ChronoField.YEAR.range();
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporal) {
                return temporal.isSupported(ChronoField.EPOCH_DAY) && Field.isIso(temporal);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
                return ChronoField.YEAR.range();
            }

            @Override
            public long getFrom(TemporalAccessor temporal) {
                if (!temporal.isSupported(this)) {
                    throw new DateTimeException("Unsupported field: WeekBasedYear");
                }
                return Field.getWeekBasedYear(LocalDate.from(temporal));
            }

            @Override
            public <R extends Temporal> R adjustInto(R temporal, long newValue) {
                if (!this.isSupportedBy(temporal)) {
                    throw new DateTimeException("Unsupported field: WeekBasedYear");
                }
                int newVal = this.range().checkValidIntValue(newValue, WEEK_BASED_YEAR);
                LocalDate date = LocalDate.from(temporal);
                int week = Field.getWeek(date);
                date = date.withDayOfYear(180).withYear(newVal).with(WEEK_OF_WEEK_BASED_YEAR, week);
                return (R)date.with(date);
            }
        };

        private static final int[] QUARTER_DAYS;

        @Override
        public int compare(TemporalAccessor temporal1, TemporalAccessor temporal2) {
            return Long.compare(temporal1.getLong(this), temporal2.getLong(this));
        }

        @Override
        public Map<TemporalField, Long> resolve(TemporalAccessor temporal, long value) {
            return null;
        }

        public String toString() {
            return this.getName();
        }

        private static boolean isIso(TemporalAccessor temporal) {
            return Chronology.from(temporal).equals(IsoChronology.INSTANCE);
        }

        private static ValueRange getWeekRange(LocalDate date) {
            int wby = Field.getWeekBasedYear(date);
            if ((date = date.withDayOfYear(1).withYear(wby)).getDayOfWeek() == DayOfWeek.THURSDAY || date.getDayOfWeek() == DayOfWeek.WEDNESDAY && date.isLeapYear()) {
                return ValueRange.of(1L, 53L);
            }
            return ValueRange.of(1L, 52L);
        }

        private static int getWeek(LocalDate date) {
            int alignedWeek;
            int dow0 = date.getDayOfWeek().ordinal();
            int doy0 = date.getDayOfYear() - 1;
            int doyThu0 = doy0 + (3 - dow0);
            int firstThuDoy0 = doyThu0 - (alignedWeek = doyThu0 / 7) * 7;
            int firstMonDoy0 = firstThuDoy0 - 3;
            if (firstMonDoy0 < -3) {
                firstMonDoy0 += 7;
            }
            if (doy0 < firstMonDoy0) {
                return (int)Field.getWeekRange(date.withDayOfYear(180).minusYears(1L)).getMaximum();
            }
            int week = (doy0 - firstMonDoy0) / 7 + 1;
            if (week == 53 && !(firstMonDoy0 == -3 || firstMonDoy0 == -2 && date.isLeapYear())) {
                week = 1;
            }
            return week;
        }

        private static int getWeekBasedYear(LocalDate date) {
            int year = date.getYear();
            int doy = date.getDayOfYear();
            if (doy <= 3) {
                int dow = date.getDayOfWeek().ordinal();
                if (doy - dow < -2) {
                    --year;
                }
            } else if (doy >= 363) {
                int dow = date.getDayOfWeek().ordinal();
                if ((doy = doy - 363 - (date.isLeapYear() ? 1 : 0)) - dow >= 0) {
                    ++year;
                }
            }
            return year;
        }

        static {
            QUARTER_DAYS = new int[]{0, 90, 181, 273, 0, 91, 182, 274};
        }
    }
}

