/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.ChronoZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporal;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

public abstract class DefaultInterfaceChronoZonedDateTime<D extends ChronoLocalDate<D>>
extends DefaultInterfaceTemporal
implements ChronoZonedDateTime<D> {
    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.INSTANT_SECONDS || field == ChronoField.OFFSET_SECONDS) {
                return field.range();
            }
            return this.toLocalDateTime().range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    throw new DateTimeException("Field too large for an int: " + field);
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.toLocalDateTime().get(field);
        }
        return super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.toLocalDateTime().getLong(field);
        }
        return field.getFrom(this);
    }

    @Override
    public ChronoLocalDate<D> toLocalDate() {
        return this.toLocalDateTime().toLocalDate();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.toLocalDateTime().toLocalTime();
    }

    @Override
    public ChronoZonedDateTime<D> with(TemporalAdjuster adjuster) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.with(adjuster));
    }

    @Override
    public ChronoZonedDateTime<D> plus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.plus(amount));
    }

    @Override
    public ChronoZonedDateTime<D> minus(TemporalAmount amount) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.minus(amount));
    }

    @Override
    public ChronoZonedDateTime<D> minus(long amountToSubtract, TemporalUnit unit) {
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(super.minus(amountToSubtract, unit));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.zoneId()) {
            return (R)this.getZone();
        }
        if (query == TemporalQueries.chronology()) {
            return (R)this.toLocalDate().getChronology();
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (query == TemporalQueries.offset()) {
            return (R)this.getOffset();
        }
        if (query == TemporalQueries.localDate()) {
            return (R)LocalDate.ofEpochDay(this.toLocalDate().toEpochDay());
        }
        if (query == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        return super.query(query);
    }

    @Override
    public Instant toInstant() {
        return Instant.ofEpochSecond(this.toEpochSecond(), this.toLocalTime().getNano());
    }

    @Override
    public long toEpochSecond() {
        long epochDay = this.toLocalDate().toEpochDay();
        long secs = epochDay * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return secs -= (long)this.getOffset().getTotalSeconds();
    }

    @Override
    public int compareTo(ChronoZonedDateTime<?> other) {
        int cmp = Long.compare(this.toEpochSecond(), other.toEpochSecond());
        if (cmp == 0 && (cmp = this.toLocalTime().getNano() - other.toLocalTime().getNano()) == 0 && (cmp = this.toLocalDateTime().compareTo(other.toLocalDateTime())) == 0 && (cmp = this.getZone().getId().compareTo(other.getZone().getId())) == 0) {
            cmp = this.toLocalDate().getChronology().compareTo(other.toLocalDate().getChronology());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoZonedDateTime<?> other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec > (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() > other.toLocalTime().getNano();
    }

    @Override
    public boolean isBefore(ChronoZonedDateTime<?> other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec < (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() < other.toLocalTime().getNano();
    }

    @Override
    public boolean isEqual(ChronoZonedDateTime<?> other) {
        return this.toEpochSecond() == other.toEpochSecond() && this.toLocalTime().getNano() == other.toLocalTime().getNano();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoZonedDateTime) {
            return this.compareTo((ChronoZonedDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toLocalDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    @Override
    public String toString() {
        String str = this.toLocalDateTime().toString() + this.getOffset().toString();
        if (this.getOffset() != this.getZone()) {
            str = str + '[' + this.getZone().toString() + ']';
        }
        return str;
    }

    @Override
    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

