/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

import java.util.Objects;
import org.threeten.bp.LocalTime;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.Era;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporal;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalUnit;

public abstract class DefaultInterfaceChronoLocalDate<D extends ChronoLocalDate<D>>
extends DefaultInterfaceTemporal
implements ChronoLocalDate<D> {
    @Override
    public Era getEra() {
        return this.getChronology().eraOf(this.get(ChronoField.ERA));
    }

    @Override
    public boolean isLeapYear() {
        return this.getChronology().isLeapYear(this.getLong(ChronoField.YEAR));
    }

    @Override
    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return ((ChronoField)field).isDateField();
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ChronoLocalDate<D> with(TemporalAdjuster adjuster) {
        return this.getChronology().ensureChronoLocalDate(super.with(adjuster));
    }

    @Override
    public ChronoLocalDate<D> plus(TemporalAmount amount) {
        return this.getChronology().ensureChronoLocalDate(super.plus(amount));
    }

    @Override
    public ChronoLocalDate<D> minus(TemporalAmount amount) {
        return this.getChronology().ensureChronoLocalDate(super.minus(amount));
    }

    @Override
    public ChronoLocalDate<D> minus(long amountToSubtract, TemporalUnit unit) {
        return this.getChronology().ensureChronoLocalDate(super.minus(amountToSubtract, unit));
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toEpochDay());
    }

    @Override
    public ChronoLocalDateTime<D> atTime(LocalTime localTime) {
        return Chronology.dateTime(this, localTime);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)this.getChronology();
        }
        return super.query(query);
    }

    @Override
    public long toEpochDay() {
        return this.getLong(ChronoField.EPOCH_DAY);
    }

    @Override
    public int compareTo(ChronoLocalDate<?> other) {
        int cmp = Long.compare(this.toEpochDay(), other.toEpochDay());
        if (cmp == 0) {
            cmp = this.getChronology().compareTo(other.getChronology());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDate<?> other) {
        return this.toEpochDay() > other.toEpochDay();
    }

    @Override
    public boolean isBefore(ChronoLocalDate<?> other) {
        return this.toEpochDay() < other.toEpochDay();
    }

    @Override
    public boolean isEqual(ChronoLocalDate<?> other) {
        return this.toEpochDay() == other.toEpochDay();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoLocalDate) {
            return this.compareTo((ChronoLocalDate)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long epDay = this.toEpochDay();
        return this.getChronology().hashCode() ^ (int)(epDay ^ epDay >>> 32);
    }

    @Override
    public String toString() {
        long yoe = this.getLong(ChronoField.YEAR_OF_ERA);
        long moy = this.getLong(ChronoField.MONTH_OF_YEAR);
        long dom = this.getLong(ChronoField.DAY_OF_MONTH);
        StringBuilder buf = new StringBuilder(30);
        buf.append(this.getChronology().toString()).append(" ").append(this.getEra()).append(" ").append(yoe).append(moy < 10L ? "-0" : "-").append(moy).append(dom < 10L ? "-0" : "-").append(dom);
        return buf.toString();
    }

    @Override
    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }
}

