/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.Clock;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.chrono.ChronoZonedDateTime;
import org.threeten.bp.chrono.Chronology;
import org.threeten.bp.chrono.Era;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.chrono.MinguoDate;
import org.threeten.bp.chrono.MinguoEra;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.ValueRange;

public final class MinguoChronology
extends Chronology
implements Serializable {
    public static final MinguoChronology INSTANCE = new MinguoChronology();
    public static final Era ERA_ROC = MinguoEra.ROC;
    public static final Era ERA_BEFORE_ROC = MinguoEra.BEFORE_ROC;
    private static final long serialVersionUID = 1039765215346859963L;
    static final int YEARS_DIFFERENCE = 1911;

    private MinguoChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Minguo";
    }

    @Override
    public String getCalendarType() {
        return "roc";
    }

    public MinguoDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return (MinguoDate)super.date(era, yearOfEra, month, dayOfMonth);
    }

    public MinguoDate date(int prolepticYear, int month, int dayOfMonth) {
        return new MinguoDate(LocalDate.of(prolepticYear + 1911, month, dayOfMonth));
    }

    public MinguoDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return (MinguoDate)super.dateYearDay(era, yearOfEra, dayOfYear);
    }

    public MinguoDate dateYearDay(int prolepticYear, int dayOfYear) {
        return new MinguoDate(LocalDate.ofYearDay(prolepticYear + 1911, dayOfYear));
    }

    public MinguoDate date(TemporalAccessor temporal) {
        if (temporal instanceof MinguoDate) {
            return (MinguoDate)temporal;
        }
        return new MinguoDate(LocalDate.from(temporal));
    }

    public ChronoLocalDateTime<MinguoDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<MinguoDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<MinguoDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    public MinguoDate dateNow() {
        return (MinguoDate)super.dateNow();
    }

    public MinguoDate dateNow(ZoneId zone) {
        return (MinguoDate)super.dateNow(zone);
    }

    public MinguoDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return (MinguoDate)super.dateNow(clock);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return IsoChronology.INSTANCE.isLeapYear(prolepticYear + 1911L);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof MinguoEra)) {
            throw new DateTimeException("Era must be MinguoEra");
        }
        return era == MinguoEra.ROC ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public Era eraOf(int eraValue) {
        return MinguoEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(MinguoEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case YEAR_OF_ERA: {
                ValueRange range = ChronoField.YEAR.range();
                return ValueRange.of(1L, range.getMaximum() - 1911L, -range.getMinimum() + 1L + 1911L);
            }
            case YEAR: {
                ValueRange range = ChronoField.YEAR.range();
                return ValueRange.of(range.getMinimum() - 1911L, range.getMaximum() - 1911L);
            }
        }
        return field.range();
    }
}

