/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.util.Comparator;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.chrono.ChronoLocalDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalAmount;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;

public interface ChronoZonedDateTime<D extends ChronoLocalDate<D>>
extends Temporal,
Comparable<ChronoZonedDateTime<?>> {
    public static final Comparator<ChronoZonedDateTime<?>> INSTANT_COMPARATOR = new Comparator<ChronoZonedDateTime<?>>(){

        @Override
        public int compare(ChronoZonedDateTime<?> datetime1, ChronoZonedDateTime<?> datetime2) {
            int cmp = Long.compare(datetime1.toEpochSecond(), datetime2.toEpochSecond());
            if (cmp == 0) {
                cmp = Long.compare(datetime1.toLocalTime().toNanoOfDay(), datetime2.toLocalTime().toNanoOfDay());
            }
            return cmp;
        }
    };

    public ChronoLocalDate<D> toLocalDate();

    public LocalTime toLocalTime();

    public ChronoLocalDateTime<D> toLocalDateTime();

    public ZoneOffset getOffset();

    public ZoneId getZone();

    public ChronoZonedDateTime<D> withEarlierOffsetAtOverlap();

    public ChronoZonedDateTime<D> withLaterOffsetAtOverlap();

    public ChronoZonedDateTime<D> withZoneSameLocal(ZoneId var1);

    public ChronoZonedDateTime<D> withZoneSameInstant(ZoneId var1);

    @Override
    public ChronoZonedDateTime<D> with(TemporalAdjuster var1);

    @Override
    public ChronoZonedDateTime<D> with(TemporalField var1, long var2);

    @Override
    public ChronoZonedDateTime<D> plus(TemporalAmount var1);

    @Override
    public ChronoZonedDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    public ChronoZonedDateTime<D> minus(TemporalAmount var1);

    @Override
    public ChronoZonedDateTime<D> minus(long var1, TemporalUnit var3);

    public Instant toInstant();

    public long toEpochSecond();

    @Override
    public int compareTo(ChronoZonedDateTime<?> var1);

    public boolean isBefore(ChronoZonedDateTime<?> var1);

    public boolean isAfter(ChronoZonedDateTime<?> var1);

    public boolean isEqual(ChronoZonedDateTime<?> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public String toString(DateTimeFormatter var1);
}

