/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Gather specific elements from the TensorArray into output `value`.
 * <p>
 * All elements selected by `indices` must have the same shape.
 * 
 * @param <T> data type for {@code value()} output
 */
@Operator
public final class TensorArrayGather<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.TensorArrayGather}
   */
  public static class Options {
    
    /**
     * @param elementShape The expected shape of an element, if known. Used to
     * validate the shapes of TensorArray elements. If this shape is not
     * fully specified, gathering zero-size TensorArrays is an error.
     */
    public Options elementShape(Shape elementShape) {
      this.elementShape = elementShape;
      return this;
    }
    
    private Shape elementShape;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new TensorArrayGather operation to the graph.
   * 
   * @param scope current graph scope
   * @param handle The handle to a TensorArray.
   * @param indices The locations in the TensorArray from which to read tensor elements.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @param dtype The type of the elem that is returned.
   * @param options carries optional attributes values
   * @return a new instance of TensorArrayGather
   */
  public static <T> TensorArrayGather<T> create(Scope scope, Operand<?> handle, Operand<Integer> indices, Operand<Float> flowIn, Class<T> dtype, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("TensorArrayGatherV3", scope.makeOpName("TensorArrayGather"));
    opBuilder.addInput(handle.asOutput());
    opBuilder.addInput(indices.asOutput());
    opBuilder.addInput(flowIn.asOutput());
    opBuilder.setAttr("dtype", DataType.fromClass(dtype));
    if (options != null) {
      for (Options opts : options) {
        if (opts.elementShape != null) {
          opBuilder.setAttr("element_shape", opts.elementShape);
        }
      }
    }
    return new TensorArrayGather<T>(opBuilder.build());
  }
  
  /**
   * @param elementShape The expected shape of an element, if known. Used to
   * validate the shapes of TensorArray elements. If this shape is not
   * fully specified, gathering zero-size TensorArrays is an error.
   */
  public static Options elementShape(Shape elementShape) {
    return new Options().elementShape(elementShape);
  }
  
  /**
   * All of the elements in the TensorArray, concatenated along a new
   * axis (the new dimension 0).
   */
  public Output<T> value() {
    return value;
  }
  
  @Override
  public Output<T> asOutput() {
    return value;
  }
  
  private Output<T> value;
  
  private TensorArrayGather(Operation operation) {
    super(operation);
    int outputIdx = 0;
    value = operation.output(outputIdx++);
  }
}
