/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Restores a tensor from checkpoint files.
 * <p>
 * Reads a tensor stored in one or several files. If there are several files (for
 * instance because a tensor was saved as slices), `file_pattern` may contain
 * wildcard symbols (`*` and `?`) in the filename portion only, not in the
 * directory portion.
 * <p>
 * If a `file_pattern` matches several files, `preferred_shard` can be used to hint
 * in which file the requested tensor is likely to be found. This op will first
 * open the file at index `preferred_shard` in the list of matching files and try
 * to restore tensors from that file.  Only if some tensors or tensor slices are
 * not found in that first file, then the Op opens all the files. Setting
 * `preferred_shard` to match the value passed as the `shard` input
 * of a matching `Save` Op may speed up Restore.  This attribute only affects
 * performance, not correctness.  The default value -1 means files are processed in
 * order.
 * <p>
 * See also `RestoreSlice`.
 * 
 * @param <T> data type for {@code tensor()} output
 */
@Operator
public final class Restore<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.Restore}
   */
  public static class Options {
    
    /**
     * @param preferredShard Index of file to open first if multiple files match
     * `file_pattern`.
     */
    public Options preferredShard(Long preferredShard) {
      this.preferredShard = preferredShard;
      return this;
    }
    
    private Long preferredShard;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new Restore operation to the graph.
   * 
   * @param scope current graph scope
   * @param filePattern Must have a single element. The pattern of the files from
   * which we read the tensor.
   * @param tensorName Must have a single element. The name of the tensor to be
   * restored.
   * @param dt The type of the tensor to be restored.
   * @param options carries optional attributes values
   * @return a new instance of Restore
   */
  public static <T> Restore<T> create(Scope scope, Operand<String> filePattern, Operand<String> tensorName, Class<T> dt, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Restore", scope.makeOpName("Restore"));
    opBuilder.addInput(filePattern.asOutput());
    opBuilder.addInput(tensorName.asOutput());
    opBuilder.setAttr("dt", DataType.fromClass(dt));
    if (options != null) {
      for (Options opts : options) {
        if (opts.preferredShard != null) {
          opBuilder.setAttr("preferred_shard", opts.preferredShard);
        }
      }
    }
    return new Restore<T>(opBuilder.build());
  }
  
  /**
   * @param preferredShard Index of file to open first if multiple files match
   * `file_pattern`.
   */
  public static Options preferredShard(Long preferredShard) {
    return new Options().preferredShard(preferredShard);
  }
  
  /**
   * The restored tensor.
   */
  public Output<T> tensor() {
    return tensor;
  }
  
  @Override
  public Output<T> asOutput() {
    return tensor;
  }
  
  private Output<T> tensor;
  
  private Restore(Operation operation) {
    super(operation);
    int outputIdx = 0;
    tensor = operation.output(outputIdx++);
  }
}
